/*
 * Decompiled with CFR 0.152.
 */
package com.tc.entity;

import com.tc.entity.VoltronEntityAppliedResponse;
import com.tc.entity.VoltronEntityMessage;
import com.tc.exception.ServerException;
import com.tc.exception.ServerExceptionType;
import com.tc.io.TCByteBufferInputStream;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.EntityID;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.session.SessionID;
import com.tc.object.tx.TransactionID;
import com.tc.util.Assert;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class VoltronEntityAppliedResponseImpl
extends DSOMessageBase
implements VoltronEntityAppliedResponse {
    private TransactionID transactionID;
    private boolean isSuccess;
    private byte[] successResponse;
    private Exception failureException;
    private static byte HYDRATE_EXCEPTION_HANDLING_VERSION_NAME = 0;
    private static byte HYDRATE_EXCEPTION_HANDLING_VERSION_0 = 0;
    private static byte HYDRATE_EXCEPTION_HANDLING_VERSION_1 = 1;

    @Override
    public VoltronEntityMessage.Acks getAckType() {
        return VoltronEntityMessage.Acks.COMPLETED;
    }

    @Override
    public void setSuccess(TransactionID transactionID, byte[] response) {
        Assert.assertNull(this.transactionID);
        Assert.assertNull(this.successResponse);
        Assert.assertNull(this.failureException);
        Assert.assertNotNull(transactionID);
        Assert.assertNotNull(response);
        this.transactionID = transactionID;
        this.isSuccess = true;
        this.successResponse = response;
    }

    @Override
    public void setFailure(TransactionID transactionID, ServerException exception) {
        Assert.assertNull(this.transactionID);
        Assert.assertNull(this.successResponse);
        Assert.assertNull(this.failureException);
        Assert.assertNotNull(transactionID);
        Assert.assertNotNull(exception);
        this.transactionID = transactionID;
        this.isSuccess = false;
        this.failureException = exception;
    }

    public VoltronEntityAppliedResponseImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public VoltronEntityAppliedResponseImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBufferInputStream data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    protected void dehydrateValues() {
        TCByteBufferOutputStream outputStream = this.getOutputStream();
        this.putNVPair(HYDRATE_EXCEPTION_HANDLING_VERSION_NAME, HYDRATE_EXCEPTION_HANDLING_VERSION_1);
        outputStream.writeLong(this.transactionID.toLong());
        outputStream.writeBoolean(this.isSuccess);
        if (this.isSuccess) {
            Assert.assertNotNull(this.successResponse);
            outputStream.writeInt(this.successResponse.length);
            outputStream.write(this.successResponse);
        } else {
            Assert.assertNotNull(this.failureException);
            outputStream.writeInt(((ServerException)this.failureException).getType().ordinal());
            outputStream.writeString(((ServerException)this.failureException).getClassName());
            outputStream.writeString(((ServerException)this.failureException).getEntityName());
            outputStream.writeString(this.failureException.getMessage());
            Throwable cause = this.failureException.getCause();
            if (cause != null) {
                StackTraceElement[] stack = cause.getStackTrace();
                ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
                try (ObjectOutputStream objectOutput2 = new ObjectOutputStream(byteOutput);){
                    objectOutput2.writeObject(stack);
                }
                catch (IOException objectOutput2) {
                    // empty catch block
                }
                byte[] serializedException = byteOutput.toByteArray();
                outputStream.writeInt(serializedException.length);
                outputStream.write(serializedException);
            } else {
                outputStream.writeInt(0);
            }
        }
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        Assert.assertTrue(0 == name);
        Assert.assertTrue(null == this.transactionID);
        byte version = this.getByteValue();
        this.transactionID = new TransactionID(this.getLongValue());
        this.isSuccess = this.getBooleanValue();
        if (this.isSuccess) {
            this.successResponse = this.getBytesArray();
        } else if (version == HYDRATE_EXCEPTION_HANDLING_VERSION_1) {
            ServerExceptionType type = ServerExceptionType.values()[this.getIntValue()];
            String cname = this.getStringValue();
            String ename = this.getStringValue();
            String description = this.getStringValue();
            byte[] objStream = this.getBytesArray();
            StackTraceElement[] cause = null;
            if (objStream.length > 0) {
                ByteArrayInputStream byteInput = new ByteArrayInputStream(objStream);
                try (ObjectInputStream objectInput = new ObjectInputStream(byteInput);){
                    cause = (StackTraceElement[])objectInput.readObject();
                }
                catch (IOException | ClassNotFoundException exception) {
                    // empty catch block
                }
            }
            this.failureException = ServerException.hydrateException(new EntityID(cname, ename), description, type, cause);
        } else if (version == HYDRATE_EXCEPTION_HANDLING_VERSION_0) {
            ByteArrayInputStream byteInput = new ByteArrayInputStream(this.getBytesArray());
            try (ObjectInputStream objectInput = new ObjectInputStream(byteInput);){
                this.failureException = (Exception)objectInput.readObject();
            }
            catch (ClassNotFoundException e) {
                this.failureException = e;
            }
        } else {
            throw new IOException("unknown exception handling version");
        }
        return true;
    }

    @Override
    public TransactionID getTransactionID() {
        return this.transactionID;
    }

    @Override
    public byte[] getSuccessValue() {
        return this.successResponse;
    }

    @Override
    public Exception getFailureException() {
        return this.failureException;
    }
}

