/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.service;

import java.util.Objects;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.service.ClusterConfigMismatchException;

public class MutualClusterValidator {
    private final Cluster major;
    private final Cluster minor;

    public MutualClusterValidator(Cluster major, Cluster minor) {
        this.major = major;
        this.minor = minor;
    }

    public void validate() throws ClusterConfigMismatchException {
        if (!Objects.equals(this.major.getName(), this.minor.getName())) {
            this.fail("cluster-name", this.major.getName(), this.minor.getName());
        }
        if (!Objects.equals(this.major.getClientLeaseDuration(), this.minor.getClientLeaseDuration())) {
            this.fail("client-lease-duration", this.major.getClientLeaseDuration(), this.minor.getClientLeaseDuration());
        }
        if (!Objects.equals(this.major.getClientReconnectWindow(), this.minor.getClientReconnectWindow())) {
            this.fail("client-reconnect-window", this.major.getClientReconnectWindow(), this.minor.getClientReconnectWindow());
        }
        if (!Objects.equals(this.major.getFailoverPriority(), this.minor.getFailoverPriority())) {
            this.fail("failover-priority", this.major.getFailoverPriority(), this.minor.getFailoverPriority());
        }
        if (!Objects.equals(this.major.getOffheapResources(), this.minor.getOffheapResources())) {
            this.fail("offheap-resources", this.major.getOffheapResources(), this.minor.getOffheapResources());
        }
        if (!Objects.equals(this.major.getSecurityAuthc(), this.minor.getSecurityAuthc())) {
            this.fail("authc", this.major.getSecurityAuthc(), this.minor.getSecurityAuthc());
        }
        if (!Objects.equals(this.major.getSecuritySslTls(), this.minor.getSecuritySslTls())) {
            this.fail("ssl-tls", this.major.getSecuritySslTls(), this.minor.getSecuritySslTls());
        }
        if (!Objects.equals(this.major.getSecurityWhitelist(), this.minor.getSecurityWhitelist())) {
            this.fail("whitelist", this.major.getSecurityWhitelist(), this.minor.getSecurityWhitelist());
        }
    }

    private <T> void fail(String settingName, T majorSetting, T minorSetting) {
        throw new ClusterConfigMismatchException("Mismatch found in " + settingName + " setting between target cluster with nodes: " + this.major.getInternalEndpoints() + " and incoming cluster with nodes: " + this.minor.getInternalEndpoints() + ". Expected value: " + majorSetting + ", but found: " + minorSetting);
    }
}

