/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import java.math.BigInteger;
import java.util.Base64;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;

public final class UID {
    private final String value;

    private UID(String value) {
        this.value = Objects.requireNonNull(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UID)) {
            return false;
        }
        UID uid = (UID)o;
        return this.value.equals(uid.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value;
    }

    public static UID valueOf(String v) {
        Objects.requireNonNull(v);
        if (!UID.isUID(v)) {
            throw new IllegalArgumentException("Not a UID: " + v);
        }
        return new UID(v);
    }

    public static UID newUID() {
        UUID uuid = UUID.randomUUID();
        return new UID(UID.encodeB64(UID.toBytes(new long[]{uuid.getMostSignificantBits(), uuid.getLeastSignificantBits()})));
    }

    public static UID newUID(Random r) {
        byte[] bytes = new byte[16];
        r.nextBytes(bytes);
        bytes[6] = (byte)(bytes[6] & 0xF);
        bytes[6] = (byte)(bytes[6] | 0x40);
        bytes[8] = (byte)(bytes[8] & 0x3F);
        bytes[8] = (byte)(bytes[8] | 0x80);
        return new UID(UID.encodeB64(bytes));
    }

    public static boolean isUID(String s) {
        try {
            byte[] decoded = UID.decodeB64(s);
            return decoded.length == 16;
        }
        catch (Exception e) {
            return false;
        }
    }

    static long[] toLongs(byte[] buffer) {
        int i;
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(buffer[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(buffer[i] & 0xFF);
        }
        return new long[]{msb, lsb};
    }

    static String toHex(byte[] b) {
        return new BigInteger(1, b).toString(16);
    }

    static byte[] toBytes(long[] longs) {
        int i;
        long msb = longs[0];
        long lsb = longs[1];
        byte[] bytes = new byte[16];
        for (i = 7; i >= 0; --i) {
            bytes[i] = (byte)(msb & 0xFFL);
            msb >>>= 8;
        }
        for (i = 15; i >= 8; --i) {
            bytes[i] = (byte)(lsb & 0xFFL);
            lsb >>>= 8;
        }
        return bytes;
    }

    static String encodeB64(byte[] data) {
        return Base64.getEncoder().encodeToString(data).replace('+', '-').replace('/', '_').replace("=", "");
    }

    static byte[] decodeB64(String s) {
        return Base64.getDecoder().decode(s.replace('-', '+').replace('_', '/'));
    }
}

