/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.stream.IntStream;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.FailoverPriority;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.Stripe;

public class Testing {
    public static Cluster newTestCluster(String name, Stripe ... stripes) {
        return new Cluster(Arrays.asList(stripes)).setUID("c-uid").setFailoverPriority(FailoverPriority.availability()).setName(name);
    }

    public static Cluster newTestCluster() {
        return Testing.newTestCluster((String)null);
    }

    public static Cluster newTestCluster(String name) {
        return new Cluster(Collections.emptyList()).setUID("c-uid").setFailoverPriority(FailoverPriority.availability()).setName(name);
    }

    public static Cluster newTestCluster(Stripe ... stripes) {
        return new Cluster(stripes).setUID("c-uid").setFailoverPriority(FailoverPriority.availability());
    }

    public static Stripe newTestStripe(String name) {
        return Testing.newTestStripe(name, "s-uid-1");
    }

    public static Stripe newTestStripe(String name, String uid) {
        return new Stripe().setUID(uid).setName(name);
    }

    public static Node newTestNode(String name, String hostname, int port) {
        return Testing.newTestNode(name, hostname, port, "n-uid-1");
    }

    public static Node newTestNode(String name, String hostname) {
        return Testing.newTestNode(name, hostname, "n-uid-1");
    }

    public static Node newTestNode(String name, String hostname, int port, String uid) {
        return new Node().setUID(uid).setName(name).setPort(port).setHostname(hostname);
    }

    public static Node newTestNode(String name, String hostname, String uid) {
        return new Node().setUID(uid).setName(name).setHostname(hostname);
    }

    public static void replaceUIDs(Cluster cluster) {
        if (cluster.getUID() != null) {
            cluster.setUID("c-uid");
        }
        IntStream.rangeClosed(1, cluster.getStripeCount()).forEach(stripeId -> {
            Stripe stripe = cluster.getStripe(stripeId).get();
            if (stripe.getUID() != null) {
                stripe.setUID("s-uid-" + stripeId);
            }
            IntStream.rangeClosed(1, stripe.getNodeCount()).forEach(nodeId -> {
                Node node = stripe.getNode(nodeId).get();
                if (node.getUID() != null) {
                    node.setUID("uid-" + stripeId + "-" + nodeId);
                }
            });
        });
    }

    public static void replaceRequiredUIDs(Cluster cluster, String placeholder) {
        if (cluster.getUID() != null) {
            cluster.setUID(placeholder);
        }
        IntStream.rangeClosed(1, cluster.getStripeCount()).forEach(stripeId -> {
            Stripe stripe = cluster.getStripe(stripeId).get();
            if (stripe.getUID() != null) {
                stripe.setUID(placeholder);
            }
            IntStream.rangeClosed(1, stripe.getNodeCount()).forEach(nodeId -> {
                Node node = stripe.getNode(nodeId).get();
                if (node.getUID() != null) {
                    node.setUID(placeholder);
                }
            });
        });
    }

    public static void replaceRequiredNames(Cluster cluster, String placeholder) {
        IntStream.rangeClosed(1, cluster.getStripeCount()).forEach(stripeId -> {
            Stripe stripe = cluster.getStripe(stripeId).get();
            if (stripe.getName() != null) {
                stripe.setName(placeholder);
            }
            IntStream.rangeClosed(1, stripe.getNodeCount()).forEach(nodeId -> {
                Node node = stripe.getNode(nodeId).get();
                if (node.getName() != null) {
                    node.setName(placeholder);
                }
            });
        });
    }

    public static void resetRequiredUIDs(Cluster cluster, String placeholder) {
        cluster.setUID(placeholder);
        IntStream.rangeClosed(1, cluster.getStripeCount()).forEach(stripeId -> {
            Stripe stripe = cluster.getStripe(stripeId).get();
            stripe.setUID(placeholder);
            IntStream.rangeClosed(1, stripe.getNodeCount()).forEach(nodeId -> {
                Node node = stripe.getNode(nodeId).get();
                node.setUID(placeholder);
            });
        });
    }

    public static void resetRequiredNames(Cluster cluster, String placeholder) {
        IntStream.rangeClosed(1, cluster.getStripeCount()).forEach(stripeId -> {
            Stripe stripe = cluster.getStripe(stripeId).get();
            stripe.setName(placeholder);
            IntStream.rangeClosed(1, stripe.getNodeCount()).forEach(nodeId -> {
                Node node = stripe.getNode(nodeId).get();
                node.setName(placeholder);
            });
        });
    }
}

