/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.tripwire;

import java.util.concurrent.atomic.LongAdder;
import jdk.jfr.FlightRecorder;
import org.terracotta.tripwire.StageEvent;
import org.terracotta.tripwire.StageMonitor;

class StageMonitorImpl
implements StageMonitor {
    private final String stage;
    private final int threads;
    private final LongAdder count = new LongAdder();
    private final LongAdder runtime = new LongAdder();
    private volatile StageEvent event;
    private volatile int min = Integer.MAX_VALUE;
    private volatile int max = 0;
    private final Runnable runnable = () -> {
        StageEvent e = this.newEvent();
        if (e != null) {
            e.setStats(this.getCount(), this.min, this.max, this.getRuntime());
            this.min = Integer.MAX_VALUE;
            this.max = 0;
            if (e.hasCount()) {
                e.commit();
            }
        }
    };

    StageMonitorImpl(String target, int threads) {
        this.stage = target;
        this.threads = threads;
    }

    private StageEvent newEvent() {
        StageEvent e = this.event;
        this.event = new StageEvent(this.stage, this.threads);
        this.event.begin();
        return e;
    }

    @Override
    public void eventOccurred(int backlog, long run) {
        this.min = Math.min(this.min, backlog);
        this.max = Math.max(this.max, backlog);
        this.runtime.add(run);
        this.count.increment();
    }

    private int getCount() {
        return (int)this.count.sumThenReset();
    }

    private long getRuntime() {
        return this.runtime.sumThenReset();
    }

    @Override
    public void register() {
        FlightRecorder.addPeriodicEvent(StageEvent.class, this.runnable);
    }

    @Override
    public void unregister() {
        FlightRecorder.removePeriodicEvent(this.runnable);
    }
}

