/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.ClusterState;
import org.terracotta.dynamic_config.api.model.Configuration;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.Operation;
import org.terracotta.dynamic_config.api.model.Requirement;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Setting;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.Substitutor;
import org.terracotta.dynamic_config.api.service.IParameterSubstitutor;

class ConfigurationParser {
    private final List<Configuration> configurations;
    private final Consumer<Configuration> defaultAddedListener;

    private ConfigurationParser(List<Configuration> configurations, Consumer<Configuration> defaultAddedListener) {
        this.configurations = new ArrayList<Configuration>((Collection)Objects.requireNonNull(configurations));
        this.defaultAddedListener = Objects.requireNonNull(defaultAddedListener);
        if (configurations.isEmpty()) {
            throw new IllegalArgumentException("No configuration provided");
        }
    }

    public Cluster parse() {
        Cluster cluster = new Cluster(new Stripe[0]);
        Stream.of(Setting.values()).filter(setting -> setting.requires(Requirement.RESOLVE_EAGERLY)).filter(setting -> setting.isScope(Scope.CLUSTER)).forEach(setting -> {
            Optional<Configuration> configuration = this.configurations.stream().filter(cfg -> cfg.getSetting() == setting).findAny();
            if (configuration.isPresent()) {
                configuration.get().apply(cluster);
                this.configurations.remove(configuration.get());
            } else {
                Optional<String> def = setting.getDefaultProperty();
                if (def.isPresent()) {
                    if (Substitutor.containsSubstitutionParams(def.get())) {
                        throw new IllegalArgumentException("Required setting: '" + (Object)setting + "' is missing");
                    }
                    setting.setProperty(cluster, def.get());
                    this.defaultAddedListener.accept(Configuration.valueOf((Object)setting + "=" + def.get()));
                } else {
                    throw new IllegalArgumentException("Required setting: '" + (Object)setting + "' is missing");
                }
            }
        });
        TreeMap configurationMap = this.configurations.stream().filter(configuration -> configuration.getLevel() == Scope.NODE).collect(Collectors.groupingBy(Configuration::getStripeId, TreeMap::new, Collectors.groupingBy(Configuration::getNodeId, TreeMap::new, Collectors.toList())));
        if (configurationMap.isEmpty()) {
            configurationMap.put(1, new TreeMap());
        }
        if (((TreeMap)configurationMap.firstEntry().getValue()).isEmpty()) {
            ((TreeMap)configurationMap.firstEntry().getValue()).put(1, new ArrayList());
        }
        if ((Integer)configurationMap.firstKey() != 1) {
            throw new IllegalArgumentException("Stripe ID must start at 1");
        }
        if (((Integer)configurationMap.lastKey()).intValue() != configurationMap.size()) {
            throw new IllegalArgumentException("Stripe ID must end at " + configurationMap.size());
        }
        configurationMap.forEach((stripeId, nodeCounts) -> {
            if ((Integer)nodeCounts.firstKey() != 1) {
                throw new IllegalArgumentException("Node ID must start at 1 in stripe " + stripeId);
            }
            if (((Integer)nodeCounts.lastKey()).intValue() != nodeCounts.size()) {
                throw new IllegalArgumentException("Node ID must end at " + nodeCounts.size() + " in stripe " + stripeId);
            }
        });
        this.configurations.forEach(configuration -> {
            if (!configuration.getSetting().allows(Operation.IMPORT)) {
                throw new IllegalArgumentException("Invalid input: '" + configuration + "'. Reason: now allowed");
            }
            if (configuration.getLevel() == Scope.STRIPE) {
                throw new IllegalArgumentException("Invalid input: '" + configuration + "'. Reason: stripe level configuration not allowed");
            }
            configuration.validate(ClusterState.CONFIGURING, Operation.IMPORT);
        });
        configurationMap.forEach((stripeId, nodeConfigurationsMap) -> {
            Stripe stripe = new Stripe();
            nodeConfigurationsMap.forEach((nodeId, nodeConfigurations) -> {
                Node node = new Node();
                stripe.addNode(node);
                if (stripe.getNodeCount() != nodeId.intValue()) {
                    throw new AssertionError((Object)("Expected node count to be: " + nodeId + " but was: " + stripe.getNodeCount()));
                }
                Stream.of(Setting.values()).filter(setting -> setting.requires(Requirement.RESOLVE_EAGERLY)).filter(setting -> setting.isScope(Scope.NODE)).forEach(setting -> {
                    Optional<Configuration> configuration = nodeConfigurations.stream().filter(cfg -> cfg.getSetting() == setting).findAny();
                    if (configuration.isPresent()) {
                        configuration.get().apply(node);
                        this.configurations.remove(configuration.get());
                    } else {
                        Optional<String> def = setting.getDefaultProperty();
                        if (def.isPresent()) {
                            if (Substitutor.containsSubstitutionParams(def.get())) {
                                throw new IllegalArgumentException("Required setting: '" + (Object)setting + "' is missing for node ID: " + nodeId + " in stripe ID: " + stripeId);
                            }
                            setting.setProperty(node, def.get());
                            this.defaultAddedListener.accept(Configuration.valueOf("stripe." + stripeId + ".node." + nodeId + "." + (Object)setting + "=" + def.get()));
                        } else {
                            throw new IllegalArgumentException("Required setting: '" + (Object)setting + "' is missing for node ID: " + nodeId + " in stripe ID: " + stripeId);
                        }
                    }
                });
            });
            cluster.addStripe(stripe);
            if (cluster.getStripeCount() != stripeId.intValue()) {
                throw new AssertionError((Object)("Expected stripe count to be: " + stripeId + " but was: " + cluster.getStripeCount()));
            }
        });
        this.configurations.forEach(configuration -> configuration.apply(cluster));
        return cluster;
    }

    static Cluster parsePropertyConfiguration(Properties properties, Consumer<Configuration> defaultAddedListener) {
        return new ConfigurationParser(ConfigurationParser.propertiesToConfigurations(properties), defaultAddedListener).parse();
    }

    static Cluster parseCommandLineParameters(Map<Setting, String> userConsoleParameters, IParameterSubstitutor substitutor, Consumer<Configuration> defaultAddedListener) {
        Properties properties = ConfigurationParser.cliToProperties(userConsoleParameters, substitutor, defaultAddedListener);
        return ConfigurationParser.parsePropertyConfiguration(properties, defaultAddedListener);
    }

    private static List<Configuration> propertiesToConfigurations(Properties properties) {
        Objects.requireNonNull(properties);
        return properties.entrySet().stream().map(p -> Configuration.valueOf(p.getKey() + "=" + p.getValue())).collect(Collectors.toList());
    }

    private static Properties cliToProperties(Map<Setting, String> cliParameters, IParameterSubstitutor parameterSubstitutor, Consumer<Configuration> defaultAddedListener) {
        Objects.requireNonNull(cliParameters);
        Properties properties = new Properties();
        cliParameters.forEach((k, v) -> properties.setProperty(ConfigurationParser.prefixed(k), (String)v));
        Stream.of(Setting.values()).filter(setting -> setting.requires(Requirement.RESOLVE_EAGERLY)).forEach(s -> ConfigurationParser.eagerlyResolve(parameterSubstitutor, defaultAddedListener, properties, s));
        return properties;
    }

    private static void eagerlyResolve(IParameterSubstitutor parameterSubstitutor, Consumer<Configuration> defaultAddedListener, Properties properties, Setting setting) {
        String key = ConfigurationParser.prefixed(setting);
        String set = properties.getProperty(key);
        if (set == null) {
            set = parameterSubstitutor.substitute(setting.getDefaultProperty().orElse(""));
            defaultAddedListener.accept(Configuration.valueOf(key + "=" + set));
        } else {
            set = parameterSubstitutor.substitute(set);
        }
        properties.setProperty(key, set);
    }

    private static String prefixed(Setting setting) {
        return setting.isScope(Scope.CLUSTER) ? setting.toString() : "stripe.1.node.1." + (Object)((Object)setting);
    }
}

