/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.entity.topology.client;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.Configuration;
import org.terracotta.dynamic_config.api.model.License;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.entity.topology.client.DynamicTopologyEntity;
import org.terracotta.dynamic_config.entity.topology.common.Message;
import org.terracotta.dynamic_config.entity.topology.common.Response;
import org.terracotta.dynamic_config.entity.topology.common.Type;
import org.terracotta.entity.EndpointDelegate;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.entity.InvokeFuture;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.exception.EntityException;

class DynamicTopologyEntityImpl
implements DynamicTopologyEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicTopologyEntityImpl.class);
    private final EntityClientEndpoint<Message, Response> endpoint;
    private final DynamicTopologyEntity.Settings settings;
    private volatile DynamicTopologyEntity.Listener listener = new DynamicTopologyEntity.Listener(){};

    public DynamicTopologyEntityImpl(EntityClientEndpoint<Message, Response> endpoint, DynamicTopologyEntity.Settings settings) {
        this.endpoint = endpoint;
        this.settings = settings == null ? new DynamicTopologyEntity.Settings() : settings;
        endpoint.setDelegate(new EndpointDelegate<Response>(){

            @Override
            public void handleMessage(Response messageFromServer) {
                switch (messageFromServer.getType()) {
                    case EVENT_NODE_ADDITION: {
                        List payload = (List)messageFromServer.getPayload();
                        DynamicTopologyEntityImpl.this.listener.onNodeAddition((Integer)payload.get(0), (Node)payload.get(1));
                        break;
                    }
                    case EVENT_NODE_REMOVAL: {
                        List payload = (List)messageFromServer.getPayload();
                        DynamicTopologyEntityImpl.this.listener.onNodeRemoval((Integer)payload.get(0), (Node)payload.get(1));
                        break;
                    }
                    case EVENT_SETTING_CHANGED: {
                        List payload = (List)messageFromServer.getPayload();
                        DynamicTopologyEntityImpl.this.listener.onSettingChange((Configuration)payload.get(0), (Cluster)payload.get(1));
                        break;
                    }
                    case EVENT_STRIPE_ADDITION: {
                        List payload = (List)messageFromServer.getPayload();
                        DynamicTopologyEntityImpl.this.listener.onStripeAddition((Stripe)payload.get(0));
                        break;
                    }
                    case EVENT_STRIPE_REMOVAL: {
                        List payload = (List)messageFromServer.getPayload();
                        DynamicTopologyEntityImpl.this.listener.onStripeRemoval((Stripe)payload.get(0));
                        break;
                    }
                    default: {
                        throw new AssertionError(messageFromServer);
                    }
                }
            }

            @Override
            public byte[] createExtendedReconnectData() {
                return new byte[0];
            }

            @Override
            public void didDisconnectUnexpectedly() {
                DynamicTopologyEntityImpl.this.listener.onDisconnected();
            }
        });
    }

    @Override
    public void close() {
        this.endpoint.close();
    }

    @Override
    public void setListener(DynamicTopologyEntity.Listener listener) {
        this.listener = listener == null ? new DynamicTopologyEntity.Listener(){} : listener;
    }

    @Override
    public Cluster getUpcomingCluster() throws TimeoutException, InterruptedException {
        return this.request(Type.REQ_UPCOMING_CLUSTER, Cluster.class);
    }

    @Override
    public Cluster getRuntimeCluster() throws TimeoutException, InterruptedException {
        return this.request(Type.REQ_RUNTIME_CLUSTER, Cluster.class);
    }

    @Override
    public boolean mustBeRestarted() throws TimeoutException, InterruptedException {
        return this.request(Type.REQ_MUST_BE_RESTARTED, Boolean.TYPE);
    }

    @Override
    public boolean hasIncompleteChange() throws TimeoutException, InterruptedException {
        return this.request(Type.REQ_HAS_INCOMPLETE_CHANGE, Boolean.TYPE);
    }

    @Override
    public License getLicense() throws TimeoutException, InterruptedException {
        return this.request(Type.REQ_LICENSE, License.class);
    }

    @Override
    public Future<Void> releaseEntity() {
        return this.endpoint.release();
    }

    public <T> T request(Type messageType, Class<T> type) throws TimeoutException, InterruptedException {
        LOGGER.trace("request({})", (Object)messageType);
        Duration requestTimeout = this.settings.getRequestTimeout();
        try {
            InvokeFuture<Response> invoke = this.endpoint.beginInvoke().message(new Message(messageType)).invoke();
            Response response = requestTimeout == null ? invoke.get() : invoke.getWithTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
            LOGGER.trace("response({})", (Object)response);
            return type.cast(response.getPayload());
        }
        catch (MessageCodecException | EntityException e) {
            throw new AssertionError((Object)e);
        }
    }
}

