/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Scanner;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.ClusterState;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.api.model.Operation;
import org.terracotta.dynamic_config.api.model.Requirement;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Setting;
import org.terracotta.dynamic_config.api.model.Substitutor;

public class Configuration {
    private static final Collection<String> SETTINGS = Stream.of(Setting.values()).map(Setting::toString).collect(Collectors.toSet());
    private static final Map<Pattern, BiFunction<String, Matcher, Configuration>> CLUSTER_PATTERNS = new LinkedHashMap<Pattern, BiFunction<String, Matcher, Configuration>>();
    private static final Map<Pattern, BiFunction<String, Matcher, Configuration>> STRIPE_PATTERNS = new LinkedHashMap<Pattern, BiFunction<String, Matcher, Configuration>>();
    private static final Map<Pattern, BiFunction<String, Matcher, Configuration>> NODE_PATTERNS = new LinkedHashMap<Pattern, BiFunction<String, Matcher, Configuration>>();
    private static final String GRP_STRIPE = "stripe\\.(\\d+)";
    private static final String GRP_NODE = "node\\.(\\d+)";
    private static final String SEP = "\\.";
    private static final String NS = "[.:]";
    private static final String GRP_SETTING = "([a-z\\-]+)";
    private static final String GRP_KEY = "([^=:]+)";
    private static final String ASSIGN = "=";
    private static final String GRP_VALUE = "([^=]+)";
    private final String rawInput;
    private final Setting setting;
    private final Scope scope;
    private final Integer stripeId;
    private final Integer nodeId;
    private final String key;
    private final String value;

    private Configuration(String rawInput, Setting setting, Scope scope, Integer stripeId, Integer nodeId, String key, String value) {
        this.rawInput = Objects.requireNonNull(rawInput);
        this.setting = Objects.requireNonNull(setting);
        this.scope = Objects.requireNonNull(scope);
        this.stripeId = stripeId;
        this.nodeId = nodeId;
        this.key = key;
        this.value = value == null || value.trim().isEmpty() ? null : value.trim();
        this.preValidate(value);
    }

    public Scope getScope() {
        return this.scope;
    }

    public int getStripeId() {
        return this.stripeId;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public Setting getSetting() {
        return this.setting;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    private void preValidate(String rawValue) {
        if (!this.setting.isMap() && this.key != null) {
            throw new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: Setting '" + (Object)((Object)this.setting) + "' is not a map and must not have a key");
        }
        if (this.stripeId != null && this.stripeId <= 0) {
            throw new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: Expected stripe ID to be greater than 0");
        }
        if (this.nodeId != null && this.nodeId <= 0) {
            throw new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: Expected node ID to be greater than 0");
        }
        if (!this.setting.allows(this.scope)) {
            throw new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: Setting '" + (Object)((Object)this.setting) + "' does not allow any operation at " + (Object)((Object)this.scope) + " level");
        }
        if (rawValue == null) {
            if (!this.setting.allows(Operation.GET) && !this.setting.allows(Operation.UNSET)) {
                throw new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: Setting '" + (Object)((Object)this.setting) + "' cannot be read or cleared");
            }
        } else if (rawValue.isEmpty()) {
            if (this.setting.mustBePresent() || !this.setting.canBeCleared(this.scope)) {
                throw new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: Setting '" + (Object)((Object)this.setting) + "' requires a value");
            }
        } else {
            if (!this.setting.allows(Operation.SET) && !this.setting.allows(Operation.IMPORT)) {
                throw new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: Setting '" + (Object)((Object)this.setting) + "' cannot be set");
            }
            if (!this.setting.allows(Operation.SET, this.scope) && !this.setting.allows(Operation.IMPORT, this.scope)) {
                throw new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: Setting '" + (Object)((Object)this.setting) + "' cannot be set at " + (Object)((Object)this.scope) + " level");
            }
            if (!Substitutor.containsSubstitutionParams(this.value)) {
                try {
                    this.setting.validate(this.key, this.value);
                }
                catch (RuntimeException e) {
                    throw new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: " + e.getMessage(), e);
                }
            }
        }
    }

    public void validate(ClusterState clusterState, Operation operation) {
        if (!clusterState.supports(operation)) {
            throw new AssertionError((Object)("Programmatic mistake: tried to validate operation " + (Object)((Object)operation) + " when " + (Object)((Object)clusterState)));
        }
        if (!this.setting.allows(operation)) {
            throw new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: Setting '" + (Object)((Object)this.setting) + "' cannot be " + (Object)((Object)operation));
        }
        if (!this.setting.allows(clusterState, operation)) {
            throw new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: Setting '" + (Object)((Object)this.setting) + "' cannot be " + (Object)((Object)operation) + " when " + (Object)((Object)clusterState));
        }
        if (!this.setting.allows(clusterState, operation, this.scope)) {
            throw new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: Setting '" + (Object)((Object)this.setting) + "' cannot be " + (Object)((Object)operation) + " at " + (Object)((Object)this.scope) + " level when " + (Object)((Object)clusterState));
        }
        switch (operation) {
            case GET: 
            case UNSET: {
                if (this.value == null) break;
                throw new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: Operation " + (Object)((Object)operation) + " must not have a value");
            }
            case SET: {
                if (this.value != null) break;
                throw new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: Operation " + (Object)((Object)operation) + " requires a value");
            }
            case IMPORT: {
                if (this.value == null && this.setting.mustBePresent()) {
                    throw new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: Operation " + (Object)((Object)operation) + " requires a value");
                }
                if (!this.setting.requires(Requirement.RESOLVE_EAGERLY) || !Substitutor.containsSubstitutionParams(this.value)) break;
                throw new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Placeholders are not allowed");
            }
            default: {
                throw new AssertionError((Object)operation);
            }
        }
    }

    public boolean duplicates(Configuration other) throws IllegalArgumentException {
        if (this.setting != other.setting) {
            return false;
        }
        if (this.scope != other.scope) {
            return false;
        }
        if (!Objects.equals(this.stripeId, other.stripeId) || !Objects.equals(this.nodeId, other.nodeId)) {
            return false;
        }
        if (!this.setting.isMap()) {
            return true;
        }
        if (this.key != null && other.key != null && Objects.equals(this.key, other.key)) {
            return true;
        }
        if (this.key != null && other.key != null && !Objects.equals(this.key, other.key)) {
            return false;
        }
        if (this.key == null && other.key == null && Objects.equals(this.value, other.value)) {
            return true;
        }
        throw new IllegalArgumentException("Incompatible or duplicate configurations: " + this + " and " + other);
    }

    public boolean matchConfigPropertyKey(String key) {
        Configuration configPropertyKey = Configuration.valueOf(key);
        if (configPropertyKey.setting != this.setting) {
            return false;
        }
        if (this.stripeId != null && !Objects.equals(this.stripeId, configPropertyKey.stripeId)) {
            return false;
        }
        if (this.nodeId != null && !Objects.equals(this.nodeId, configPropertyKey.nodeId)) {
            return false;
        }
        if (this.setting.isMap() && this.key != null && !Objects.equals(this.key, configPropertyKey.key)) {
            return false;
        }
        return !this.setting.isMap() || this.key != null || configPropertyKey.key == null;
    }

    public Collection<NodeContext> apply(Cluster cluster) {
        Collection<NodeContext> targets = this.getTargets(cluster);
        if (this.value == null) {
            targets.forEach(ctx -> this.setting.getProperty((NodeContext)ctx).ifPresent(value -> this.setting.setProperty((NodeContext)ctx, this.key, null)));
        } else {
            targets.forEach(ctx -> this.setting.setProperty((NodeContext)ctx, this.key, this.value));
        }
        return targets;
    }

    public void apply(Node node) {
        if (this.value == null) {
            this.setting.getProperty(node).ifPresent(value -> this.setting.setProperty(node, this.key, null));
        } else {
            this.setting.setProperty(node, this.key, this.value);
        }
    }

    public int hashCode() {
        return this.rawInput.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration that = (Configuration)o;
        return this.rawInput.equals(that.rawInput);
    }

    public String toString() {
        return this.rawInput;
    }

    private Collection<NodeContext> getTargets(Cluster cluster) {
        Collection targetContexts;
        switch (this.scope) {
            case CLUSTER: {
                targetContexts = cluster.nodeContexts().collect(Collectors.toList());
                break;
            }
            case STRIPE: {
                targetContexts = cluster.getStripe(this.stripeId).orElseThrow(() -> new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: Invalid stripe ID: " + this.stripeId + ". Cluster contains: " + cluster.getStripeCount() + " stripe(s)")).getNodes().stream().map(node -> new NodeContext(cluster, (int)this.stripeId, node.getName())).collect(Collectors.toList());
                break;
            }
            case NODE: {
                targetContexts = Stream.of(new NodeContext(cluster, (int)this.stripeId, cluster.getStripe(this.stripeId).orElseThrow(() -> new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: Invalid stripe ID: " + this.stripeId + ". Cluster contains: " + cluster.getStripeCount() + " stripe(s)")).getNode(this.nodeId).orElseThrow(() -> new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: Invalid node ID: " + this.nodeId + ". Stripe ID: " + this.stripeId + " contains: " + cluster.getStripe(this.stripeId).get().getNodeCount() + " node(s)")).getName())).collect(Collectors.toList());
                break;
            }
            default: {
                throw new AssertionError((Object)this.scope);
            }
        }
        return targetContexts;
    }

    public static Configuration valueOf(String key, String value) {
        return Configuration.valueOf(key + ASSIGN + (value == null ? "" : value));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Configuration valueOf(String input) {
        Matcher matcher;
        Objects.requireNonNull(input);
        input = input.trim();
        Integer stripeId = null;
        Integer nodeId = null;
        Setting setting = null;
        try (Scanner scanner = new Scanner(input).useDelimiter("[.:=]");){
            block19: while (scanner.hasNext() && setting == null) {
                String next;
                switch (next = scanner.next()) {
                    case "stripe": {
                        if (stripeId != null) {
                            throw new IllegalArgumentException("Invalid input: '" + input + "'");
                        }
                        stripeId = scanner.nextInt(10);
                        continue block19;
                    }
                    case "node": {
                        if (nodeId != null || stripeId == null) {
                            throw new IllegalArgumentException("Invalid input: '" + input + "'");
                        }
                        nodeId = scanner.nextInt(10);
                        continue block19;
                    }
                }
                if (!SETTINGS.contains(next)) {
                    throw new IllegalArgumentException("Invalid input: '" + input + "'. Reason: Invalid setting name: '" + next + "'");
                }
                setting = Setting.fromName(next);
            }
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("Invalid input: '" + input + "'");
        }
        if (setting == null) {
            throw new IllegalArgumentException("Invalid input: '" + input + "'. Reason: valid setting name not found");
        }
        if (stripeId != null && nodeId != null) {
            for (Map.Entry<Pattern, BiFunction<String, Matcher, Configuration>> entry : NODE_PATTERNS.entrySet()) {
                matcher = entry.getKey().matcher(input);
                if (!matcher.matches()) continue;
                return entry.getValue().apply(input, matcher);
            }
        }
        if (stripeId != null && nodeId == null) {
            for (Map.Entry<Pattern, BiFunction<String, Matcher, Configuration>> entry : STRIPE_PATTERNS.entrySet()) {
                matcher = entry.getKey().matcher(input);
                if (!matcher.matches()) continue;
                return entry.getValue().apply(input, matcher);
            }
        }
        if (stripeId == null) {
            for (Map.Entry<Pattern, BiFunction<String, Matcher, Configuration>> entry : CLUSTER_PATTERNS.entrySet()) {
                matcher = entry.getKey().matcher(input);
                if (!matcher.matches()) continue;
                return entry.getValue().apply(input, matcher);
            }
        }
        throw new IllegalArgumentException("Invalid input: '" + input + "'");
    }

    public static Configuration valueOf(Setting setting) {
        String val = setting.getDefaultValue();
        if (val == null) {
            val = "";
        }
        return new Configuration((Object)((Object)setting) + ASSIGN + val, setting, Scope.CLUSTER, null, null, null, val);
    }

    public static Configuration valueOf(Setting setting, int stripeId) {
        String val = setting.getDefaultValue();
        if (val == null) {
            val = "";
        }
        return new Configuration("stripe." + stripeId + "." + (Object)((Object)setting) + ASSIGN + val, setting, Scope.STRIPE, stripeId, null, null, val);
    }

    public static Configuration valueOf(Setting setting, int stripeId, int nodeId) {
        String val = setting.getDefaultValue();
        if (val == null) {
            val = "";
        }
        return new Configuration("stripe." + stripeId + ".node." + nodeId + "." + (Object)((Object)setting) + ASSIGN + val, setting, Scope.NODE, stripeId, nodeId, null, val);
    }

    static {
        NODE_PATTERNS.put(Pattern.compile("^stripe\\.(\\d+)\\.node\\.(\\d+)[.:]([a-z\\-]+)\\.([^=:]+)=([^=]+)$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(3)), Scope.NODE, Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), matcher.group(4), matcher.group(5)));
        NODE_PATTERNS.put(Pattern.compile("^stripe\\.(\\d+)\\.node\\.(\\d+)[.:]([a-z\\-]+)=([^=]+)$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(3)), Scope.NODE, Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), null, matcher.group(4)));
        STRIPE_PATTERNS.put(Pattern.compile("^stripe\\.(\\d+)[.:]([a-z\\-]+)\\.([^=:]+)=([^=]+)$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(2)), Scope.STRIPE, Integer.parseInt(matcher.group(1)), null, matcher.group(3), matcher.group(4)));
        STRIPE_PATTERNS.put(Pattern.compile("^stripe\\.(\\d+)[.:]([a-z\\-]+)=([^=]+)$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(2)), Scope.STRIPE, Integer.parseInt(matcher.group(1)), null, null, matcher.group(3)));
        CLUSTER_PATTERNS.put(Pattern.compile("^([a-z\\-]+)\\.([^=:]+)=([^=]+)$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(1)), Scope.CLUSTER, null, null, matcher.group(2), matcher.group(3)));
        CLUSTER_PATTERNS.put(Pattern.compile("^([a-z\\-]+)=([^=]+)$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(1)), Scope.CLUSTER, null, null, null, matcher.group(2)));
        NODE_PATTERNS.put(Pattern.compile("^stripe\\.(\\d+)\\.node\\.(\\d+)[.:]([a-z\\-]+)\\.([^=:]+)=$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(3)), Scope.NODE, Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), matcher.group(4), ""));
        NODE_PATTERNS.put(Pattern.compile("^stripe\\.(\\d+)\\.node\\.(\\d+)[.:]([a-z\\-]+)=$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(3)), Scope.NODE, Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), null, ""));
        STRIPE_PATTERNS.put(Pattern.compile("^stripe\\.(\\d+)[.:]([a-z\\-]+)\\.([^=:]+)=$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(2)), Scope.STRIPE, Integer.parseInt(matcher.group(1)), null, matcher.group(3), ""));
        STRIPE_PATTERNS.put(Pattern.compile("^stripe\\.(\\d+)[.:]([a-z\\-]+)=$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(2)), Scope.STRIPE, Integer.parseInt(matcher.group(1)), null, null, ""));
        CLUSTER_PATTERNS.put(Pattern.compile("^([a-z\\-]+)\\.([^=:]+)=$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(1)), Scope.CLUSTER, null, null, matcher.group(2), ""));
        CLUSTER_PATTERNS.put(Pattern.compile("^([a-z\\-]+)=$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(1)), Scope.CLUSTER, null, null, null, ""));
        NODE_PATTERNS.put(Pattern.compile("^stripe\\.(\\d+)\\.node\\.(\\d+)[.:]([a-z\\-]+)\\.([^=:]+)$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(3)), Scope.NODE, Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), matcher.group(4), null));
        NODE_PATTERNS.put(Pattern.compile("^stripe\\.(\\d+)\\.node\\.(\\d+)[.:]([a-z\\-]+)$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(3)), Scope.NODE, Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), null, null));
        STRIPE_PATTERNS.put(Pattern.compile("^stripe\\.(\\d+)[.:]([a-z\\-]+)\\.([^=:]+)$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(2)), Scope.STRIPE, Integer.parseInt(matcher.group(1)), null, matcher.group(3), null));
        STRIPE_PATTERNS.put(Pattern.compile("^stripe\\.(\\d+)[.:]([a-z\\-]+)$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(2)), Scope.STRIPE, Integer.parseInt(matcher.group(1)), null, null, null));
        CLUSTER_PATTERNS.put(Pattern.compile("^([a-z\\-]+)\\.([^=:]+)$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(1)), Scope.CLUSTER, null, null, matcher.group(2), null));
        CLUSTER_PATTERNS.put(Pattern.compile("^([a-z\\-]+)$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(1)), Scope.CLUSTER, null, null, null, null));
    }
}

