/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.service;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.Setting;
import org.terracotta.dynamic_config.api.service.MalformedClusterException;

public class ClusterValidator {
    private final Cluster cluster;

    public ClusterValidator(Cluster cluster) {
        this.cluster = cluster;
    }

    public void validate() throws MalformedClusterException {
        this.validateNodeName();
        this.validateAddresses();
        this.validateDataDirs();
        this.validateSecurityDir();
        this.validateFailoverSetting();
    }

    private void validateAddresses() {
        this.checkDuplicateInternalAddresses();
        this.checkPublicAddressContent();
        this.checkDuplicatePublicAddresses();
        this.checkAllOrNoPublicAddresses();
    }

    private void checkAllOrNoPublicAddresses() {
        List nodesWithNoPublicAddresses = this.cluster.getStripes().stream().flatMap(s -> s.getNodes().stream()).filter(node -> !node.getNodePublicAddress().isPresent()).map(Node::getNodeName).collect(Collectors.toList());
        if (nodesWithNoPublicAddresses.size() != 0 && nodesWithNoPublicAddresses.size() != this.cluster.getNodeCount()) {
            throw new MalformedClusterException("Nodes with names: " + nodesWithNoPublicAddresses + " don't have public addresses defined, but other nodes in the cluster do. Public addresses, if configured, need to be defined on all nodes in the cluster");
        }
    }

    private void checkPublicAddressContent() {
        this.cluster.getStripes().stream().flatMap(s -> s.getNodes().stream()).filter(node -> node.getNodePublicHostname() != null && node.getNodePublicPort() == null || node.getNodePublicHostname() == null && node.getNodePublicPort() != null).findFirst().ifPresent(node -> {
            throw new MalformedClusterException("Public address: '" + node.getNodePublicHostname() + ":" + node.getNodePublicPort() + "' of node with name: " + node.getNodeName() + " isn't well-formed. Public hostname and port need to be set together");
        });
    }

    private void checkDuplicateInternalAddresses() {
        this.cluster.getStripes().stream().flatMap(s -> s.getNodes().stream()).collect(Collectors.groupingBy(Node::getNodeInternalAddress, Collectors.toList())).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).findAny().ifPresent(entry -> {
            throw new MalformedClusterException("Nodes with names: " + ((List)entry.getValue()).stream().map(Node::getNodeName).collect(Collectors.joining(", ")) + " have the same address: '" + entry.getKey() + "'");
        });
    }

    private void checkDuplicatePublicAddresses() {
        this.cluster.getStripes().stream().flatMap(s -> s.getNodes().stream()).collect(Collectors.groupingBy(Node::getNodePublicAddress, Collectors.toList())).entrySet().stream().filter(e -> ((Optional)e.getKey()).isPresent() && ((List)e.getValue()).size() > 1).findAny().ifPresent(entry -> {
            throw new MalformedClusterException("Nodes with names: " + ((List)entry.getValue()).stream().map(Node::getNodeName).collect(Collectors.joining(", ")) + " have the same public address: '" + ((Optional)entry.getKey()).get() + "'");
        });
    }

    private void validateFailoverSetting() {
        if (this.cluster.getFailoverPriority() == null) {
            throw new MalformedClusterException((Object)((Object)Setting.FAILOVER_PRIORITY) + " setting is missing");
        }
    }

    private void validateNodeName() {
        this.cluster.getNodes().stream().map(Node::getNodeName).filter(Objects::nonNull).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).findAny().ifPresent(nodeName -> {
            throw new MalformedClusterException("Found duplicate node name: " + nodeName);
        });
    }

    private void validateDataDirs() {
        Set uniqueDataDirNames = this.cluster.getNodes().stream().map(node -> node.getDataDirs().keySet()).collect(Collectors.toSet());
        if (uniqueDataDirNames.size() > 1) {
            throw new MalformedClusterException("Data directory names need to match across the cluster, but found the following mismatches: " + uniqueDataDirNames + ". Mutative operations on data dirs must be done simultaneously on every node in cluster");
        }
    }

    private void validateSecurityDir() {
        if ("certificate".equals(this.cluster.getSecurityAuthc()) && !this.cluster.isSecuritySslTls()) {
            throw new MalformedClusterException((Object)((Object)Setting.SECURITY_SSL_TLS) + " is required for " + (Object)((Object)Setting.SECURITY_AUTHC) + "=certificate");
        }
        this.cluster.nodeContexts().forEach(nodeContext -> {
            Node node = nodeContext.getNode();
            if (this.cluster.getSecurityAuthc() != null && node.getSecurityDir() == null || node.getSecurityAuditLogDir() != null && node.getSecurityDir() == null || this.cluster.isSecuritySslTls() && node.getSecurityDir() == null || this.cluster.isSecurityWhitelist() && node.getSecurityDir() == null) {
                throw new MalformedClusterException((Object)((Object)Setting.SECURITY_DIR) + " is mandatory for any of the security configuration");
            }
            if (node.getSecurityDir() != null && !this.cluster.isSecuritySslTls() && this.cluster.getSecurityAuthc() == null && !this.cluster.isSecurityWhitelist()) {
                throw new MalformedClusterException("One of " + (Object)((Object)Setting.SECURITY_SSL_TLS) + ", " + (Object)((Object)Setting.SECURITY_AUTHC) + ", or " + (Object)((Object)Setting.SECURITY_WHITELIST) + " is required for security configuration");
            }
        });
    }
}

