/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.concurrent;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class CircularLossyQueue<T> {
    private final AtomicReference<T>[] circularArray;
    private final int maxSize;
    private final AtomicLong currentIndex = new AtomicLong(-1L);

    public CircularLossyQueue(int size) {
        this.circularArray = this.initRefArray(size);
        for (int i = 0; i < size; ++i) {
            this.circularArray[i] = new AtomicReference();
        }
        this.maxSize = size;
    }

    private AtomicReference<T>[] initRefArray(int size) {
        return new AtomicReference[size];
    }

    public T push(T newVal) {
        int index = (int)(this.currentIndex.incrementAndGet() % (long)this.maxSize);
        AtomicReference<T> ref = this.circularArray[index];
        T oldVal = ref.get();
        ref.set(newVal);
        return oldVal;
    }

    public T[] toArray(T[] type) {
        if (type.length > this.maxSize) {
            throw new IllegalArgumentException("Size of array passed in cannot be greater than " + this.maxSize);
        }
        int curIndex = this.getCurrentIndex();
        for (int k = 0; k < type.length; ++k) {
            int index = this.getIndex(curIndex - k);
            type[k] = this.circularArray[index].get();
        }
        return type;
    }

    private int getIndex(int index) {
        index = index < 0 ? index + this.maxSize : index;
        return index;
    }

    public T peek() {
        if (this.depth() == 0) {
            return null;
        }
        return this.circularArray[this.getIndex(this.getCurrentIndex())].get();
    }

    public boolean isEmtpy() {
        return this.depth() == 0;
    }

    private int getCurrentIndex() {
        return (int)(this.currentIndex.get() % (long)this.maxSize);
    }

    public int depth() {
        long currInd = this.currentIndex.get() + 1L;
        return currInd >= (long)this.maxSize ? this.maxSize : (int)currInd;
    }
}

