/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.entity;

import org.terracotta.entity.ActiveServerEntity;
import org.terracotta.entity.CommonServerEntity;
import org.terracotta.entity.ConcurrencyStrategy;
import org.terracotta.entity.ConfigurationException;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.ExecutionStrategy;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.PassiveServerEntity;
import org.terracotta.entity.ServiceRegistry;
import org.terracotta.entity.SyncMessageCodec;

public interface EntityServerService<M extends EntityMessage, R extends EntityResponse> {
    public long getVersion();

    public boolean handlesEntityType(String var1);

    public ActiveServerEntity<M, R> createActiveEntity(ServiceRegistry var1, byte[] var2) throws ConfigurationException;

    public PassiveServerEntity<M, R> createPassiveEntity(ServiceRegistry var1, byte[] var2) throws ConfigurationException;

    default public <AP extends CommonServerEntity<M, R>> AP reconfigureEntity(ServiceRegistry registry, AP oldEntity, byte[] configuration) throws ConfigurationException {
        if (oldEntity instanceof PassiveServerEntity) {
            return (AP)this.createPassiveEntity(registry, configuration);
        }
        if (oldEntity instanceof ActiveServerEntity) {
            return (AP)this.createActiveEntity(registry, configuration);
        }
        throw new AssertionError((Object)"unknown entity type");
    }

    public ConcurrencyStrategy<M> getConcurrencyStrategy(byte[] var1);

    default public ExecutionStrategy<M> getExecutionStrategy(byte[] configuration) {
        return new ExecutionStrategy<M>(){

            @Override
            public ExecutionStrategy.Location getExecutionLocation(M message) {
                return ExecutionStrategy.Location.IGNORE;
            }
        };
    }

    public MessageCodec<M, R> getMessageCodec();

    public SyncMessageCodec<M> getSyncMessageCodec();
}

