/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.entity;

import org.terracotta.entity.ActiveInvokeContext;
import org.terracotta.entity.ClientDescriptor;
import org.terracotta.entity.CommonServerEntity;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.EntityUserException;
import org.terracotta.entity.PassiveSynchronizationChannel;
import org.terracotta.entity.ReconnectRejectedException;

public interface ActiveServerEntity<M extends EntityMessage, R extends EntityResponse>
extends CommonServerEntity<M, R> {
    public void connected(ClientDescriptor var1);

    public void disconnected(ClientDescriptor var1);

    default public R invokeActive(ActiveInvokeContext<R> context, M message) throws EntityUserException {
        return this.invoke(context.getClientDescriptor(), message);
    }

    @Deprecated
    default public R invoke(ClientDescriptor descriptor, M message) throws EntityUserException {
        throw new UnsupportedOperationException();
    }

    public void loadExisting();

    default public void prepareKeyForSynchronizeOnPassive(PassiveSynchronizationChannel<M> syncChannel, int concurrencyKey) {
    }

    public void synchronizeKeyToPassive(PassiveSynchronizationChannel<M> var1, int var2);

    public ReconnectHandler startReconnect();

    public static interface ReconnectHandler
    extends AutoCloseable {
        public void handleReconnect(ClientDescriptor var1, byte[] var2) throws ReconnectRejectedException;

        @Override
        default public void close() {
        }
    }
}

