/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.tripwire;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import jdk.jfr.Category;
import jdk.jfr.DataAmount;
import jdk.jfr.Label;
import jdk.jfr.Period;
import jdk.jfr.StackTrace;
import org.terracotta.tripwire.Event;

@Category(value={"Tripwire"})
@Period(value="5 s")
@Label(value="Disk")
@StackTrace(value=false)
class DiskEvent
extends jdk.jfr.Event
implements Event {
    private String path;
    @DataAmount(value="BYTES")
    private final long free;

    DiskEvent(Path path) {
        File f = path.toFile();
        this.path = path.toString();
        try {
            this.free = Files.getFileStore(path).getUsableSpace();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void setDescription(String description) {
    }
}

