/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease;

import org.terracotta.lease.Lease;
import org.terracotta.lease.LeaseInternal;
import org.terracotta.lease.TimeSource;

class LeaseImpl
implements LeaseInternal {
    private final TimeSource timeSource;
    private final long startOfContiguousLeasedPeriod;
    private final long leaseExpiry;

    LeaseImpl(TimeSource timeSource, long startOfContiguousLeasedPeriod, long leaseExpiry) {
        this.timeSource = timeSource;
        this.startOfContiguousLeasedPeriod = startOfContiguousLeasedPeriod;
        this.leaseExpiry = leaseExpiry;
    }

    @Override
    public boolean isValidAndContiguous(Lease previousLease) {
        if (!(previousLease instanceof LeaseImpl)) {
            return false;
        }
        LeaseImpl previousLeaseImpl = (LeaseImpl)previousLease;
        if (this.startOfContiguousLeasedPeriod != previousLeaseImpl.startOfContiguousLeasedPeriod) {
            return false;
        }
        return this.isValid();
    }

    @Override
    public LeaseInternal extend(TimeSource timeSource, long leaseStart, long leaseExpiry) {
        if (this.isValid()) {
            return new LeaseImpl(timeSource, this.startOfContiguousLeasedPeriod, leaseExpiry);
        }
        return new LeaseImpl(timeSource, leaseStart, leaseExpiry);
    }

    private boolean isValid() {
        long now = this.timeSource.nanoTime();
        return now - this.leaseExpiry < 0L;
    }

    public String toString() {
        return "[ LeaseImpl: startOfContiguousLeasedPeriod: " + this.startOfContiguousLeasedPeriod + " leaseExpiry: " + this.leaseExpiry + " ]";
    }
}

