/*
 * Decompiled with CFR 0.152.
 */
package com.tc.async.impl;

import com.tc.async.api.ConfigurationContext;
import com.tc.async.api.EventHandler;
import com.tc.async.api.PostInit;
import com.tc.async.api.Stage;
import com.tc.async.api.StageListener;
import com.tc.async.api.StageManager;
import com.tc.async.impl.NullStageListener;
import com.tc.async.impl.StageImpl;
import com.tc.logging.DefaultLoggerProvider;
import com.tc.logging.TCLoggerProvider;
import com.tc.properties.TCPropertiesImpl;
import com.tc.stats.Stats;
import com.tc.text.MapListPrettyPrint;
import com.tc.util.Assert;
import com.tc.util.concurrent.QueueFactory;
import com.tc.util.concurrent.ThreadUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class StageManagerImpl
implements StageManager {
    private static final boolean MONITOR = TCPropertiesImpl.getProperties().getBoolean("tc.stage.monitor.enabled");
    private static final long MONITOR_DELAY = TCPropertiesImpl.getProperties().getLong("tc.stage.monitor.delay");
    private final Map<String, Stage<?>> stages = new ConcurrentHashMap();
    private final Map<String, Class<?>> classVerifications = new ConcurrentHashMap();
    private TCLoggerProvider loggerProvider;
    private final ThreadGroup group;
    private String[] stageNames = new String[0];
    private final QueueFactory queueFactory;
    private final StageListener listener;
    private volatile boolean started;

    public StageManagerImpl(ThreadGroup threadGroup, QueueFactory queueFactory) {
        this.loggerProvider = new DefaultLoggerProvider();
        this.group = threadGroup;
        this.queueFactory = queueFactory;
        this.listener = new NullStageListener();
        if (MONITOR) {
            this.startMonitor();
        }
    }

    public StageManagerImpl(ThreadGroup threadGroup, QueueFactory queueFactory, StageListener listener) {
        this.loggerProvider = new DefaultLoggerProvider();
        this.group = threadGroup;
        this.queueFactory = queueFactory;
        this.listener = listener;
        if (MONITOR) {
            this.startMonitor();
        }
    }

    private void startMonitor() {
        final Logger logger = this.loggerProvider.getLogger(this.getClass());
        Thread t = new Thread(this.group, "SEDA Stage Monitor"){

            @Override
            public void run() {
                while (true) {
                    this.printStats();
                    ThreadUtil.reallySleep(MONITOR_DELAY);
                }
            }

            private void printStats() {
                try {
                    Stats[] stats = StageManagerImpl.this.getStats();
                    logger.info("Stage Depths");
                    logger.info("=================================");
                    for (Stats stat : stats) {
                        stat.logDetails(logger);
                    }
                }
                catch (Throwable th) {
                    logger.error("Exception :", th);
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    @Override
    public void setLoggerProvider(TCLoggerProvider loggerProvider) {
        this.loggerProvider = loggerProvider;
    }

    @Override
    public <EC> Stage<EC> createStage(String name, Class<EC> verification, EventHandler<EC> handler, int threads, int maxSize) {
        return this.createStage(name, verification, handler, threads, maxSize, false);
    }

    @Override
    public synchronized <EC> Stage<EC> createStage(String name, Class<EC> verification, EventHandler<EC> handler, int queueCount, int maxSize, boolean canBeDirect) {
        if (this.started) {
            throw new IllegalStateException("A new stage cannot be created, because StageManager is already started.");
        }
        int capacity = maxSize >= 0 ? maxSize : Integer.MAX_VALUE;
        StageImpl<EC> s = new StageImpl<EC>(this.loggerProvider, name, verification, handler, queueCount, this.group, this.queueFactory, this.listener, capacity, canBeDirect);
        this.addStage(name, s);
        this.classVerifications.put(name, verification);
        return s;
    }

    private synchronized <EC> void addStage(String name, Stage<EC> s) {
        Stage<EC> prev = this.stages.put(name, s);
        Assert.assertNull(prev);
        this.stageNames = this.stages.keySet().toArray(new String[this.stages.size()]);
        Arrays.sort(this.stageNames);
    }

    @Override
    public synchronized void startAll(ConfigurationContext context, List<PostInit> toInit, String ... exclusion) {
        for (PostInit postInit : toInit) {
            postInit.initializeContext(context);
        }
        Arrays.sort(exclusion);
        for (Stage stage : this.stages.values()) {
            if (Arrays.binarySearch(exclusion, stage.getName()) >= 0) continue;
            stage.start(context);
        }
        this.started = true;
    }

    @Override
    public void stopAll() {
        for (Stage<?> s : this.stages.values()) {
            s.destroy();
        }
        this.stages.clear();
        this.classVerifications.clear();
        this.started = false;
    }

    @Override
    public void cleanup() {
        for (Stage<?> s : this.stages.values()) {
            s.clear();
        }
    }

    @Override
    public <EC> Stage<EC> getStage(String name, Class<EC> verification) {
        Assert.assertTrue(verification.isAssignableFrom(this.classVerifications.get(name)));
        return this.stages.get(name);
    }

    @Override
    public synchronized Stats[] getStats() {
        String[] names = this.stageNames;
        Stats[] stats = new Stats[names.length];
        for (int i = 0; i < names.length; ++i) {
            final Map<String, ?> data = this.stages.get(names[i]).getState();
            stats[i] = new Stats(){

                @Override
                public String getDetails() {
                    MapListPrettyPrint pp = new MapListPrettyPrint();
                    pp.println(data);
                    return pp.toString();
                }

                @Override
                public void logDetails(Logger statsLogger) {
                    statsLogger.info(this.getDetails());
                }
            };
        }
        return stats;
    }

    @Override
    public Map<String, ?> getStateMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("className", this.getClass().getName());
        map.put("monitor", MONITOR);
        ArrayList list = new ArrayList(this.stages.size());
        for (Stage<?> stage : this.stages.values()) {
            if (!stage.isStarted()) continue;
            list.add(stage.getState());
        }
        map.put("stages", list);
        return map;
    }
}

