/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.net.core.BufferManagerFactory;
import com.tc.net.core.BufferManagerFactorySupplier;
import com.tc.net.core.ClearTextBufferManagerFactory;
import com.tc.object.ClientBuilder;
import com.tc.object.ClientBuilderFactory;
import com.tc.object.StandardClientBuilder;
import com.terracotta.diagnostic.DiagnosticClientBuilder;
import java.util.Arrays;
import java.util.Properties;

public class StandardClientBuilderFactory
implements ClientBuilderFactory {
    private final BufferManagerFactorySupplier supplier;

    public StandardClientBuilderFactory() {
        BufferManagerFactorySupplier base = ClientBuilderFactory.get(BufferManagerFactorySupplier.class);
        this.supplier = base == null ? p -> new ClearTextBufferManagerFactory() : p -> {
            BufferManagerFactory factory = base.createBufferManagerFactory(p);
            if (factory == null) {
                return new ClearTextBufferManagerFactory();
            }
            return factory;
        };
    }

    @Override
    public ClientBuilder create(Properties connectionProperties) {
        Object clientBuilderTypeValue = connectionProperties.get("client.builder.type");
        if (clientBuilderTypeValue instanceof ClientBuilderFactory.ClientBuilderType) {
            ClientBuilderFactory.ClientBuilderType connectionType = (ClientBuilderFactory.ClientBuilderType)((Object)clientBuilderTypeValue);
            if (connectionType == ClientBuilderFactory.ClientBuilderType.TERRACOTTA) {
                return new StandardClientBuilder(connectionProperties, this.supplier.createBufferManagerFactory(connectionProperties));
            }
            if (connectionType == ClientBuilderFactory.ClientBuilderType.DIAGNOSTIC) {
                return new DiagnosticClientBuilder(connectionProperties, this.supplier.createBufferManagerFactory(connectionProperties));
            }
            throw new IllegalArgumentException((Object)((Object)connectionType) + " is not a valid client builder type, valid client builder types " + Arrays.toString((Object[])ClientBuilderFactory.ClientBuilderType.values()));
        }
        throw new IllegalArgumentException("Received invalid value (" + clientBuilderTypeValue + ") for property " + "client.builder.type" + ", valid client builder types " + Arrays.toString((Object[])ClientBuilderFactory.ClientBuilderType.values()));
    }
}

