/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.common.struct;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigInteger;
import org.terracotta.common.struct.Unit;

public enum MemoryUnit implements Unit<MemoryUnit>
{
    B(0),
    KB(10),
    MB(20),
    GB(30),
    TB(40),
    PB(50);

    private final int bitShift;

    private MemoryUnit(int bitShift) {
        this.bitShift = bitShift;
    }

    @Override
    public String getShortName() {
        return this.name();
    }

    @Override
    public BigInteger convert(BigInteger quantity, MemoryUnit unit) {
        return this == unit ? quantity : unit.toBytes(quantity).divide(this.toBytes(BigInteger.ONE));
    }

    @Override
    public MemoryUnit getBaseUnit() {
        return B;
    }

    public String toString() {
        return this.getShortName();
    }

    public long toBytes(long quantity) {
        return this.toBytes(BigInteger.valueOf(quantity)).longValueExact();
    }

    public BigInteger toBytes(BigInteger quantity) {
        if (this.bitShift == 0) {
            return quantity;
        }
        if (quantity.signum() == -1) {
            BigInteger minusOne = BigInteger.ONE.negate();
            return minusOne.multiply(this.toBytes(minusOne.multiply(quantity)));
        }
        if (quantity.equals(BigInteger.ZERO)) {
            return BigInteger.ZERO;
        }
        return quantity.shiftLeft(this.bitShift);
    }

    public static MemoryUnit parse(String s) {
        for (MemoryUnit value : MemoryUnit.values()) {
            if (!value.name().equalsIgnoreCase(s)) continue;
            return value;
        }
        throw new IllegalArgumentException(s);
    }

    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    public String toString(long quantity) {
        MemoryUnit[] units = MemoryUnit.values();
        int i = units.length - 1;
        while (units[i] != this) {
            MemoryUnit unit = units[i];
            long base = 1L << unit.bitShift - this.bitShift;
            if (quantity > base) {
                double value = (double)quantity / (double)base;
                if (value == Math.rint(value)) {
                    return String.format("%d%s", (long)value, unit);
                }
                return String.format("%3.1f%s", value, unit);
            }
            --i;
        }
        return Long.toString(quantity) + this;
    }
}

