/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.async.api.StageManager;
import com.tc.management.TCClient;
import com.tc.net.core.BufferManagerFactory;
import com.tc.net.core.ProductID;
import com.tc.net.core.TCConnectionManager;
import com.tc.net.protocol.NetworkStackHarnessFactory;
import com.tc.net.protocol.tcm.ClientMessageChannel;
import com.tc.net.protocol.tcm.CommunicationsManager;
import com.tc.net.protocol.tcm.CommunicationsManagerImpl;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessage;
import com.tc.net.protocol.tcm.TCMessageRouter;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.protocol.transport.ClientConnectionErrorListener;
import com.tc.net.protocol.transport.ConnectionPolicy;
import com.tc.net.protocol.transport.HealthCheckerConfig;
import com.tc.net.protocol.transport.ReconnectionRejectedHandler;
import com.tc.net.protocol.transport.TransportHandshakeErrorHandlerForL1;
import com.tc.object.ClientBuilder;
import com.tc.object.ClientEntityManager;
import com.tc.object.ClientEntityManagerImpl;
import com.tc.object.handshakemanager.ClientHandshakeManager;
import com.tc.object.handshakemanager.ClientHandshakeManagerImpl;
import com.tc.object.msg.ClientHandshakeMessageFactory;
import com.tc.object.session.SessionManager;
import com.tc.object.session.SessionProvider;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;

public class StandardClientBuilder
implements ClientBuilder {
    private final Properties connectionProperties;
    private volatile ClientConnectionErrorListener listener;
    private final BufferManagerFactory buffers;

    public StandardClientBuilder(Properties connectionProperties, BufferManagerFactory buffers) {
        this.connectionProperties = connectionProperties;
        this.buffers = buffers;
    }

    @Override
    public ClientMessageChannel createClientMessageChannel(CommunicationsManager commMgr, SessionProvider sessionProvider, int socketConnectTimeout, TCClient client) {
        ClientMessageChannel cmc = commMgr.createClientChannel(this.getTypeOfClient(), sessionProvider, socketConnectTimeout);
        if (this.listener != null) {
            cmc.addClientConnectionErrorListener(this.listener);
        }
        return cmc;
    }

    @Override
    public CommunicationsManager createCommunicationsManager(MessageMonitor monitor, TCMessageRouter messageRouter, NetworkStackHarnessFactory stackHarnessFactory, ConnectionPolicy connectionPolicy, TCConnectionManager connections, HealthCheckerConfig aConfig, Map<TCMessageType, Class<? extends TCMessage>> messageTypeClassMapping, ReconnectionRejectedHandler reconnectionRejectedHandler) {
        return new CommunicationsManagerImpl(monitor, messageRouter, stackHarnessFactory, connections, connectionPolicy, aConfig, new TransportHandshakeErrorHandlerForL1(), messageTypeClassMapping, reconnectionRejectedHandler, this.getBufferManagerFactory());
    }

    @Override
    public ClientHandshakeManager createClientHandshakeManager(Logger logger, ClientHandshakeMessageFactory chmf, SessionManager sessionManager, String uuid, String name, String clientVersion, ClientEntityManager entity) {
        return new ClientHandshakeManagerImpl(logger, chmf, sessionManager, uuid, name, clientVersion, entity);
    }

    @Override
    public ClientEntityManager createClientEntityManager(ClientMessageChannel channel, StageManager stages) {
        return new ClientEntityManagerImpl(channel, stages);
    }

    protected ProductID getTypeOfClient() {
        boolean noreconnect = Boolean.valueOf(this.connectionProperties.getProperty("connection.noreconnect", "false"));
        String typeName = this.connectionProperties.getProperty("connection.type");
        ProductID product = noreconnect ? ProductID.SERVER : ProductID.PERMANENT;
        try {
            if (typeName != null) {
                product = ProductID.valueOf(typeName);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return product;
    }

    @Override
    public BufferManagerFactory createBufferManagerFactory() {
        return this.getBufferManagerFactory();
    }

    protected BufferManagerFactory getBufferManagerFactory() {
        return this.buffers;
    }

    @Override
    public void setClientConnectionErrorListener(ClientConnectionErrorListener listener) {
        this.listener = listener;
    }
}

