/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.common.struct;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.math.BigInteger;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import org.terracotta.common.struct.MemoryUnit;
import org.terracotta.common.struct.TimeUnit;
import org.terracotta.common.struct.Unit;

public class Measure<T extends Enum<T>>
implements Comparable<Measure<T>> {
    private final BigInteger quantity;
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(name="TIME", value=TimeUnit.class), @JsonSubTypes.Type(name="MEMORY", value=MemoryUnit.class)})
    private final T unit;

    public static <U extends Enum<U>> Measure<U> of(long quantity, U type) {
        return new Measure<U>(BigInteger.valueOf(quantity), type);
    }

    public static <U extends Enum<U>> Measure<U> of(BigInteger quantity, U type) {
        return new Measure<U>(quantity, type);
    }

    public static <U extends Enum<U>> Measure<U> zero(Class<U> unitType) {
        return Measure.of(BigInteger.ZERO, ((Unit)((Object)((Enum[])unitType.getEnumConstants())[0])).getBaseUnit());
    }

    public static <U extends Enum<U>> Measure<U> parse(String quantityUnit, Class<U> unitType) throws IllegalArgumentException {
        return Measure.parse(quantityUnit, unitType, null, EnumSet.allOf(unitType));
    }

    public static <U extends Enum<U>> Measure<U> parse(String quantityUnit, Class<U> unitType, U defaultUnit) throws IllegalArgumentException {
        return Measure.parse(quantityUnit, unitType, defaultUnit, EnumSet.allOf(unitType));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <U extends Enum<U>> Measure<U> parse(String quantityUnit, Class<U> unitType, U defaultUnit, Collection<U> validUnits) throws IllegalArgumentException {
        void var7_10;
        BigInteger quantity;
        int i;
        Objects.requireNonNull(quantityUnit);
        Objects.requireNonNull(unitType);
        if (defaultUnit != null && !validUnits.contains(defaultUnit)) {
            throw new IllegalArgumentException("Default unit '" + ((Unit)((Object)defaultUnit)).getShortName() + "' is not in the list of valid units " + validUnits + ".");
        }
        if (quantityUnit.isEmpty()) {
            throw new IllegalArgumentException("Invalid measure. <quantity><unit> are missing.");
        }
        char[] chars = quantityUnit.toCharArray();
        if (chars[0] == '-') {
            throw new IllegalArgumentException("Quantity measure cannot be negative");
        }
        for (i = 0; i < chars.length && Character.isDigit(chars[i]); ++i) {
        }
        if (i == 0) {
            throw new IllegalArgumentException("Invalid measure: '" + quantityUnit + "'. <quantity> is missing. Measure should be specified in <quantity><unit> format.");
        }
        try {
            quantity = new BigInteger(quantityUnit.substring(0, i));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid measure: '" + quantityUnit + "'. <quantity> is not a valid number.");
        }
        if (i == quantityUnit.length()) {
            if (defaultUnit == null) throw new IllegalArgumentException("Invalid measure: '" + quantityUnit + "'. <unit> is missing. Measure should be specified in <quantity><unit> format.");
            U u2 = defaultUnit;
            return Measure.of(quantity, var7_10);
        } else {
            String q = quantityUnit.substring(i);
            Enum enum_ = validUnits.stream().filter(u -> ((Unit)((Object)u)).getShortName().equals(q)).findAny().orElseThrow(() -> new IllegalArgumentException("Invalid measure: '" + quantityUnit + "'. <unit> must be one of " + validUnits + "."));
        }
        return Measure.of(quantity, var7_10);
    }

    @JsonCreator
    private Measure(@JsonProperty(value="quantity", required=true) BigInteger quantity, @JsonProperty(value="unit", required=true) T unit) {
        this.quantity = quantity;
        this.unit = (Enum)Objects.requireNonNull(unit);
        if (quantity.signum() == -1) {
            throw new IllegalArgumentException("Quantity measure cannot be negative");
        }
    }

    @JsonIgnore
    public long getQuantity() {
        return this.quantity.longValueExact();
    }

    public long getQuantity(T unit) {
        return ((Unit)unit).convert(this.quantity, this.unit).longValueExact();
    }

    @JsonProperty(value="quantity")
    public BigInteger getExactQuantity() {
        return this.quantity;
    }

    public BigInteger getExactQuantity(T unit) {
        return ((Unit)unit).convert(this.quantity, this.unit);
    }

    public Measure<T> to(T unit) {
        return Measure.of(this.getQuantity(unit), unit);
    }

    public T getUnit() {
        return this.unit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Measure)) {
            return false;
        }
        Measure measure = (Measure)o;
        return Objects.equals(this.getExactQuantity(), measure.getExactQuantity()) && Objects.equals(this.getUnit(), measure.getUnit());
    }

    public int hashCode() {
        return Objects.hash(this.quantity, this.unit);
    }

    public String toString() {
        return this.quantity + ((Unit)this.unit).getShortName();
    }

    @Override
    public int compareTo(Measure<T> o) {
        return this.getExactQuantity(((Unit)this.unit).getBaseUnit()).compareTo(o.getExactQuantity(((Unit)o.getUnit()).getBaseUnit()));
    }
}

