/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.tx;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.io.TCByteBufferInputStream;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tc.net.groups.NodeIDSerializer;
import com.tc.object.tx.TransactionID;
import com.tc.util.Assert;

public class ServerTransactionID
implements Comparable<ServerTransactionID> {
    public static final ServerTransactionID NULL_ID = new ServerTransactionID(ClientID.NULL_ID, TransactionID.NULL_ID);
    private final TransactionID txnID;
    private final NodeID sourceID;
    private final int hashCode;

    public ServerTransactionID(NodeID source, TransactionID txnID) {
        this.sourceID = source;
        this.txnID = txnID;
        int hash = 29;
        hash = 37 * hash + source.hashCode();
        this.hashCode = hash = 37 * hash + txnID.hashCode();
    }

    public NodeID getSourceID() {
        return this.sourceID;
    }

    public TransactionID getClientTransactionID() {
        return this.txnID;
    }

    public boolean isServerGeneratedTransaction() {
        return this.sourceID.getNodeType() == 2;
    }

    public boolean isNull() {
        return this.sourceID.isNull() && this.txnID.isNull();
    }

    public String toString() {
        return new StringBuffer().append("ServerTransactionID{").append(this.sourceID).append(',').append(this.txnID).append('}').toString();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServerTransactionID) {
            ServerTransactionID other = (ServerTransactionID)obj;
            return this.sourceID.equals(other.sourceID) && this.txnID.equals(other.txnID);
        }
        return false;
    }

    public byte[] getBytes() {
        TCByteBufferOutputStream out = new TCByteBufferOutputStream(64, 256, false);
        NodeIDSerializer nodeIDSerializer = new NodeIDSerializer(this.sourceID);
        nodeIDSerializer.serializeTo(out);
        out.writeLong(this.txnID.toLong());
        out.close();
        TCByteBuffer[] bufs = out.toArray();
        byte[] toRet = new byte[out.getBytesWritten()];
        int idx = 0;
        for (TCByteBuffer buf : bufs) {
            int length = buf.limit();
            buf.get(toRet, idx, buf.limit());
            idx += length;
        }
        Assert.assertEquals(idx, out.getBytesWritten());
        return toRet;
    }

    public static ServerTransactionID createFrom(byte[] data) {
        try {
            TCByteBufferInputStream in = new TCByteBufferInputStream(TCByteBufferFactory.wrap(data));
            NodeIDSerializer nodeIDSerializer = new NodeIDSerializer();
            nodeIDSerializer.deserializeFrom(in);
            return new ServerTransactionID(nodeIDSerializer.getNodeID(), new TransactionID(in.readLong()));
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public int compareTo(ServerTransactionID other) {
        int cmp = this.sourceID.compareTo(other.sourceID);
        if (cmp == 0) {
            return this.txnID.compareTo(other.txnID);
        }
        return cmp;
    }
}

