/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease.connection;

import java.util.concurrent.TimeUnit;

public class TimeBudget {
    private final long budgetExpiry;
    private final TimeUnit timeUnit;

    public TimeBudget(long timeout, TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
        this.budgetExpiry = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeout, timeUnit);
    }

    public long remaining() {
        return this.remaining(this.timeUnit);
    }

    public long remaining(TimeUnit timeUnit) {
        long now = System.nanoTime();
        long remaining = this.budgetExpiry - now;
        return timeUnit.convert(remaining, TimeUnit.NANOSECONDS);
    }

    public String toString() {
        return "TimeBudget{budgetExpiry=" + this.budgetExpiry + ", remaining=" + this.remaining() + ", timeUnit=" + (Object)((Object)this.timeUnit) + '}';
    }
}

