/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol;

import com.tc.bytes.TCByteBuffer;
import com.tc.exception.TCInternalError;
import com.tc.net.protocol.TCNetworkHeader;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.util.Assert;
import com.tc.util.HexDump;
import com.tc.util.concurrent.SetOnceFlag;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCNetworkMessageImpl
implements TCNetworkMessage {
    protected static final Logger logger = LoggerFactory.getLogger(TCNetworkMessage.class);
    private static final int MESSAGE_DUMP_MAXBYTES = 4096;
    private final SetOnceFlag sealed = new SetOnceFlag();
    private final SetOnceFlag callbackFired = new SetOnceFlag();
    private final AtomicReference<State> state = new AtomicReference<State>(State.PENDING);
    private static final TCByteBuffer[] EMPTY_BUFFER_ARRAY = new TCByteBuffer[0];
    private final TCNetworkHeader header;
    private TCByteBuffer[] payloadData;
    private TCByteBuffer[] entireMessageData;
    private int totalLength;
    private int dataLength;
    private int headerLength;
    private final List<Runnable> callbacks = new LinkedList<Runnable>();

    protected TCNetworkMessageImpl(TCNetworkHeader header, boolean seal) {
        this(header, null, seal);
    }

    public TCNetworkMessageImpl(TCNetworkHeader header, TCByteBuffer[] payload) {
        this(header, payload, true);
    }

    private TCNetworkMessageImpl(TCNetworkHeader header, TCByteBuffer[] payload, boolean seal) {
        Assert.eval(header != null);
        this.header = header;
        TCByteBuffer[] tCByteBufferArray = this.payloadData = payload == null ? EMPTY_BUFFER_ARRAY : payload;
        if (seal) {
            this.seal();
        }
    }

    @Override
    public final int getDataLength() {
        this.checkSealed();
        return this.dataLength;
    }

    @Override
    public final int getHeaderLength() {
        this.checkSealed();
        return this.headerLength;
    }

    @Override
    public final int getTotalLength() {
        this.checkSealed();
        return this.totalLength;
    }

    @Override
    public final TCNetworkHeader getHeader() {
        return this.header;
    }

    @Override
    public final TCByteBuffer[] getPayload() {
        return this.payloadData;
    }

    protected final void setPayload(TCByteBuffer[] newPayload) {
        this.checkNotSealed();
        this.entireMessageData = null;
        this.payloadData = newPayload == null ? EMPTY_BUFFER_ARRAY : newPayload;
    }

    @Override
    public final TCByteBuffer[] getEntireMessageData() {
        this.checkSealed();
        Assert.eval(this.entireMessageData != null);
        return this.entireMessageData;
    }

    public final String toString() {
        try {
            return this.toString0();
        }
        catch (Exception e) {
            logger.warn("Exception in toString()", (Throwable)e);
            return "EXCEPTION in toString(): " + e.getMessage();
        }
    }

    protected final String toString0() {
        String payload;
        StringBuffer buf = new StringBuffer();
        buf.append("Message Class: ").append(this.getClass().getName()).append("\n");
        buf.append("Sealed: ").append(this.sealed.isSet()).append(", ");
        buf.append("Header Length: ").append(this.getHeaderLength()).append(", ");
        buf.append("Data Length: ").append(this.getDataLength()).append(", ");
        buf.append("Total Length: ").append(this.getTotalLength()).append("\n");
        String extraMsgInfo = this.describeMessage();
        if (extraMsgInfo != null) {
            buf.append(extraMsgInfo).append("\n");
        }
        if ((payload = this.describePayload()) != null) {
            buf.append(payload);
        }
        return buf.toString();
    }

    protected String describeMessage() {
        return null;
    }

    protected String describePayload() {
        return null;
    }

    protected String messageBytes() {
        StringBuffer buf = new StringBuffer();
        int totalBytesDumped = 0;
        if (this.payloadData != null && this.payloadData.length != 0) {
            for (int i = 0; i < this.payloadData.length; ++i) {
                buf.append("Buffer ").append(i).append(": ");
                if (this.payloadData[i] != null) {
                    buf.append(this.payloadData[i].toString());
                    buf.append("\n");
                    if (totalBytesDumped >= 4096) continue;
                    int bytesFullBuf = this.payloadData[i].limit();
                    int bytesToDump = totalBytesDumped + bytesFullBuf < 4096 ? bytesFullBuf : 4096 - totalBytesDumped;
                    buf.append(HexDump.dump(this.payloadData[i].array(), this.payloadData[i].arrayOffset(), bytesToDump));
                    totalBytesDumped += bytesToDump;
                    continue;
                }
                buf.append("null");
            }
        } else {
            buf.append("No payload buffers present");
        }
        return buf.toString();
    }

    protected String dump() {
        StringBuffer toRet = new StringBuffer(this.toString());
        toRet.append("\n\n");
        if (this.entireMessageData != null) {
            for (int i = 0; i < this.entireMessageData.length; ++i) {
                byte[] ba;
                toRet.append('[').append(i).append(']').append('=').append(this.entireMessageData[i].toString());
                toRet.append(" =  { ");
                for (byte element : ba = this.entireMessageData[i].array()) {
                    toRet.append(Byte.toString(element)).append(' ');
                }
                toRet.append(" }  \n\n");
            }
        }
        return toRet.toString();
    }

    @Override
    public final boolean isSealed() {
        return this.sealed.isSet();
    }

    @Override
    public final void seal() {
        long dataLen;
        if (this.sealed.attemptSet()) {
            int size = 1 + this.payloadData.length;
            this.entireMessageData = new TCByteBuffer[size];
            this.entireMessageData[0] = this.header.getDataBuffer();
            System.arraycopy(this.payloadData, 0, this.entireMessageData, 1, this.payloadData.length);
            dataLen = 0L;
            for (int i = 1; i < this.entireMessageData.length; ++i) {
                dataLen += (long)this.entireMessageData[i].remaining();
            }
            if (dataLen > Integer.MAX_VALUE) {
                throw new TCInternalError("Message too big");
            }
        } else {
            throw new IllegalStateException("Message is sealed");
        }
        this.dataLength = (int)dataLen;
        this.headerLength = this.header.getHeaderByteLength();
        this.totalLength = this.headerLength + this.dataLength;
    }

    @Override
    public void complete() {
        this.fireCallbacks();
    }

    private void fireCallbacks() {
        if (this.callbackFired.attemptSet()) {
            try {
                this.callbacks.forEach(Runnable::run);
            }
            catch (Exception e) {
                logger.error("Caught exception running sent callback", (Throwable)e);
            }
        }
    }

    @Override
    public void addCompleteCallback(Runnable r) {
        this.callbacks.add(r);
    }

    @Override
    public boolean commit() {
        return this.state.compareAndSet(State.PENDING, State.COMMITTED) || State.COMMITTED.equals((Object)this.state.get());
    }

    @Override
    public boolean cancel() {
        return this.state.compareAndSet(State.PENDING, State.CANCELLED) || State.CANCELLED.equals((Object)this.state.get());
    }

    private void checkSealed() {
        if (!this.isSealed()) {
            throw new IllegalStateException("Message is not sealed");
        }
    }

    private void checkNotSealed() {
        if (this.sealed.isSet()) {
            throw new IllegalStateException("Message is sealed");
        }
    }

    static enum State {
        PENDING,
        COMMITTED,
        CANCELLED;

    }
}

