/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.net.NodeID;
import com.tc.net.ServerID;
import com.tc.net.core.ConnectionInfo;
import com.tc.net.protocol.NetworkStackID;
import com.tc.net.protocol.tcm.AbstractMessageChannel;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.tcm.ServerMessageChannel;
import com.tc.net.protocol.tcm.TCMessageFactory;
import com.tc.net.protocol.tcm.TCMessageRouter;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.util.Assert;
import com.tc.util.ProductID;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerMessageChannelImpl
extends AbstractMessageChannel
implements ServerMessageChannel {
    private static final Logger logger = LoggerFactory.getLogger(ServerMessageChannel.class);
    private final ChannelID channel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServerMessageChannelImpl(ChannelID channel, TCMessageRouter router, TCMessageFactory msgFactory, ServerID serverID) {
        super(router, logger, msgFactory);
        this.channel = channel;
        this.setLocalNodeID(serverID);
        AbstractMessageChannel.ChannelStatus channelStatus = this.getStatus();
        synchronized (channelStatus) {
            this.channelOpened();
        }
    }

    @Override
    public ChannelID getChannelID() {
        if (this.isConnected()) {
            Assert.assertEquals(super.getChannelID(), this.channel);
            return this.channel;
        }
        return this.channel;
    }

    @Override
    public NodeID getRemoteNodeID() {
        return this.getConnectionID().getClientID();
    }

    @Override
    public ProductID getProductID() {
        return this.getProductID(ProductID.PERMANENT);
    }

    @Override
    public NetworkStackID open(Collection<ConnectionInfo> info) {
        throw new UnsupportedOperationException("Server channels don't support open()");
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("Server channels don't support reset()");
    }

    @Override
    public void notifyTransportClosed(MessageTransport transport) {
        super.notifyTransportClosed(transport);
    }

    @Override
    public void notifyTransportConnected(MessageTransport transport) {
        this.addAttachment("transportInfo", transport, true);
        super.notifyTransportConnected(transport);
    }
}

