/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema.setup.sources;

import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.config.schema.setup.sources.ConfigurationSource;
import com.tc.util.Assert;
import com.tc.util.io.ServerURL;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;

public class ServerConfigurationSource
implements ConfigurationSource {
    private final String host;
    private final int port;

    public ServerConfigurationSource(String host, int port) {
        Assert.assertNotBlank(host);
        Assert.assertTrue(port > 0);
        this.host = host;
        this.port = port;
    }

    @Override
    public InputStream getInputStream(long maxTimeoutMillis) throws IOException, ConfigurationSetupException {
        try {
            ServerURL theURL = new ServerURL(this.host, this.port, "/config", (int)maxTimeoutMillis);
            System.setProperty("sun.net.client.defaultConnectTimeout", String.valueOf(maxTimeoutMillis));
            System.setProperty("sun.net.client.defaultReadTimeout", String.valueOf(maxTimeoutMillis));
            return theURL.openStream();
        }
        catch (MalformedURLException murle) {
            throw new ConfigurationSetupException("Can't load configuration from " + this + ".");
        }
    }

    @Override
    public File directoryLoadedFrom() {
        return null;
    }

    @Override
    public boolean isTrusted() {
        return true;
    }

    public String toString() {
        return "server at '" + this.host + ":" + this.port + "'";
    }
}

