/*
 * Decompiled with CFR 0.152.
 */
package com.tc.stats.counter;

import com.tc.stats.counter.Counter;
import com.tc.stats.counter.CounterConfig;
import com.tc.stats.counter.CounterManager;
import com.tc.stats.counter.sampled.SampledCounter;
import com.tc.stats.counter.sampled.SampledCounterImpl;
import java.util.Timer;

public class CounterManagerImpl
implements CounterManager {
    private Timer timer = null;
    private boolean shutdown = false;

    @Override
    public synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        try {
            if (this.timer != null) {
                this.timer.cancel();
            }
        }
        finally {
            this.shutdown = true;
        }
    }

    @Override
    public synchronized Counter createCounter(CounterConfig config) {
        if (this.shutdown) {
            throw new IllegalStateException("counter manager is shutdown");
        }
        if (config == null) {
            throw new NullPointerException("config cannot be null");
        }
        Counter counter = config.createCounter();
        if (counter instanceof SampledCounterImpl) {
            SampledCounterImpl sampledCounter = (SampledCounterImpl)counter;
            if (this.timer == null) {
                this.timer = new Timer("SampledCounterManager Timer", true);
            }
            this.timer.schedule(sampledCounter.getTimerTask(), sampledCounter.getIntervalMillis(), sampledCounter.getIntervalMillis());
        }
        return counter;
    }

    @Override
    public void shutdownCounter(Counter counter) {
        if (counter instanceof SampledCounter) {
            SampledCounter sc = (SampledCounter)counter;
            sc.shutdown();
        }
    }
}

