/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.loaderwriter;

import java.util.Collection;
import java.util.Set;
import org.ehcache.clustered.client.internal.loaderwriter.DelegatingLoaderWriterStore;
import org.ehcache.clustered.client.service.ClusteringService;
import org.ehcache.config.ResourceType;
import org.ehcache.core.spi.service.ServiceUtils;
import org.ehcache.core.spi.store.AbstractWrapperStoreProvider;
import org.ehcache.core.spi.store.Store;
import org.ehcache.spi.loaderwriter.CacheLoaderWriterConfiguration;
import org.ehcache.spi.loaderwriter.CacheLoaderWriterProvider;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;

@ServiceDependencies(value={CacheLoaderWriterProvider.class, ClusteringService.class})
public class DelegatingLoaderWriterStoreProvider
extends AbstractWrapperStoreProvider {
    protected <K, V> Store<K, V> wrap(Store<K, V> store, Store.Configuration<K, V> storeConfig, ServiceConfiguration<?, ?> ... serviceConfigs) {
        return new DelegatingLoaderWriterStore<K, V>(store);
    }

    public int rank(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?, ?>> serviceConfigs) {
        throw new UnsupportedOperationException("Its a Wrapper store provider, does not support regular ranking");
    }

    public int wrapperStoreRank(Collection<ServiceConfiguration<?, ?>> serviceConfigs) {
        CacheLoaderWriterConfiguration loaderWriterConfiguration = (CacheLoaderWriterConfiguration)ServiceUtils.findSingletonAmongst(CacheLoaderWriterConfiguration.class, serviceConfigs);
        ClusteringService.ClusteredCacheIdentifier clusteredCacheIdentifier = (ClusteringService.ClusteredCacheIdentifier)ServiceUtils.findSingletonAmongst(ClusteringService.ClusteredCacheIdentifier.class, serviceConfigs);
        if (clusteredCacheIdentifier != null && loaderWriterConfiguration != null) {
            return 3;
        }
        return 0;
    }
}

