/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.loaderwriter;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.ehcache.clustered.client.internal.store.ClusteredStore;
import org.ehcache.clustered.client.internal.store.ClusteredValueHolder;
import org.ehcache.clustered.client.internal.store.ServerStoreProxy;
import org.ehcache.clustered.client.internal.store.lock.LockingServerStoreProxy;
import org.ehcache.clustered.client.internal.store.operations.ChainResolver;
import org.ehcache.clustered.client.internal.store.operations.EternalChainResolver;
import org.ehcache.clustered.client.service.ClusteringService;
import org.ehcache.clustered.common.internal.store.operations.ConditionalRemoveOperation;
import org.ehcache.clustered.common.internal.store.operations.ConditionalReplaceOperation;
import org.ehcache.clustered.common.internal.store.operations.PutIfAbsentOperation;
import org.ehcache.clustered.common.internal.store.operations.PutOperation;
import org.ehcache.clustered.common.internal.store.operations.RemoveOperation;
import org.ehcache.clustered.common.internal.store.operations.ReplaceOperation;
import org.ehcache.clustered.common.internal.store.operations.codecs.OperationsCodec;
import org.ehcache.config.ResourceType;
import org.ehcache.core.events.StoreEventDispatcher;
import org.ehcache.core.exceptions.ExceptionFactory;
import org.ehcache.core.exceptions.StorePassThroughException;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.tiering.AuthoritativeTier;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.core.spi.time.TimeSourceService;
import org.ehcache.impl.store.DefaultStoreEventDispatcher;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.loaderwriter.CacheLoaderWriterConfiguration;
import org.ehcache.spi.loaderwriter.CacheLoadingException;
import org.ehcache.spi.resilience.StoreAccessException;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;

public class ClusteredLoaderWriterStore<K, V>
extends ClusteredStore<K, V>
implements AuthoritativeTier<K, V> {
    private final CacheLoaderWriter<? super K, V> cacheLoaderWriter;
    private final boolean useLoaderInAtomics;

    public ClusteredLoaderWriterStore(Store.Configuration<K, V> config, OperationsCodec<K, V> codec, ChainResolver<K, V> resolver, TimeSource timeSource, CacheLoaderWriter<? super K, V> loaderWriter, boolean useLoaderInAtomics, StoreEventDispatcher<K, V> storeEventDispatcher) {
        super(config, codec, resolver, timeSource, storeEventDispatcher);
        this.cacheLoaderWriter = loaderWriter;
        this.useLoaderInAtomics = useLoaderInAtomics;
    }

    ClusteredLoaderWriterStore(Store.Configuration<K, V> config, OperationsCodec<K, V> codec, EternalChainResolver<K, V> resolver, ServerStoreProxy proxy, TimeSource timeSource, CacheLoaderWriter<? super K, V> loaderWriter) {
        super(config, codec, resolver, proxy, timeSource, null);
        this.cacheLoaderWriter = loaderWriter;
        this.useLoaderInAtomics = true;
    }

    private LockingServerStoreProxy getProxy() {
        return (LockingServerStoreProxy)this.storeProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Store.ValueHolder<V> getInternal(K key) throws StoreAccessException, TimeoutException {
        Store.ValueHolder holder = super.getInternal(key);
        try {
            if (holder != null) return holder;
            long hash = this.extractLongKey(key);
            boolean unlocked = false;
            this.getProxy().lock(hash);
            try {
                Object value;
                try {
                    value = this.cacheLoaderWriter.load(key);
                }
                catch (Exception e) {
                    throw new StorePassThroughException((Throwable)new CacheLoadingException((Throwable)e));
                }
                if (value == null) {
                    Store.ValueHolder<V> valueHolder = null;
                    return valueHolder;
                }
                this.append(key, value);
                unlocked = true;
                ClusteredValueHolder<Object> clusteredValueHolder = new ClusteredValueHolder<Object>(value);
                return clusteredValueHolder;
            }
            finally {
                this.getProxy().unlock(hash, unlocked);
            }
        }
        catch (RuntimeException re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    private void append(K key, V value) throws TimeoutException {
        PutOperation<K, V> operation = new PutOperation<K, V>(key, value, this.timeSource.getTimeMillis());
        ByteBuffer payload = this.codec.encode(operation);
        long extractedKey = this.extractLongKey(key);
        this.storeProxy.append(extractedKey, payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Store.PutStatus silentPut(K key, V value) throws StoreAccessException {
        try {
            long hash = this.extractLongKey(key);
            boolean unlocked = false;
            this.getProxy().lock(hash);
            try {
                this.cacheLoaderWriter.write(key, value);
                this.append(key, value);
                unlocked = true;
            }
            finally {
                this.getProxy().unlock(hash, unlocked);
            }
            return Store.PutStatus.PUT;
        }
        catch (Exception e) {
            throw StorePassThroughException.handleException((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean silentRemove(K key) throws StoreAccessException {
        boolean bl;
        long hash = this.extractLongKey(key);
        boolean unlocked = false;
        RemoveOperation operation = new RemoveOperation(key, this.timeSource.getTimeMillis());
        ByteBuffer payLoad = this.codec.encode(operation);
        ServerStoreProxy.ChainEntry chain = this.getProxy().lock(hash);
        try {
            this.cacheLoaderWriter.delete(key);
            this.storeProxy.append(hash, payLoad);
            unlocked = true;
            bl = this.resolver.resolve(chain, key, this.timeSource.getTimeMillis()) != null;
        }
        catch (Throwable throwable) {
            try {
                this.getProxy().unlock(hash, unlocked);
                throw throwable;
            }
            catch (Exception e) {
                throw StorePassThroughException.handleException((Exception)e);
            }
        }
        this.getProxy().unlock(hash, unlocked);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Store.ValueHolder<V> silentPutIfAbsent(K key, V value) throws StoreAccessException {
        try {
            long hash = this.extractLongKey(key);
            boolean unlocked = false;
            ServerStoreProxy.ChainEntry existing = this.getProxy().lock(hash);
            try {
                Store.ValueHolder existingVal = this.resolver.resolve(existing, key, this.timeSource.getTimeMillis());
                if (existingVal != null) {
                    Store.ValueHolder valueHolder = existingVal;
                    return valueHolder;
                }
                existingVal = this.loadFromLoaderWriter(key);
                if (existingVal == null) {
                    this.cacheLoaderWriter.write(key, value);
                    PutIfAbsentOperation<K, V> operation = new PutIfAbsentOperation<K, V>(key, value, this.timeSource.getTimeMillis());
                    ByteBuffer payload = this.codec.encode(operation);
                    this.storeProxy.append(hash, payload);
                    unlocked = true;
                }
                Store.ValueHolder valueHolder = existingVal;
                return valueHolder;
            }
            finally {
                this.getProxy().unlock(hash, unlocked);
            }
        }
        catch (Exception e) {
            throw StorePassThroughException.handleException((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Store.ValueHolder<V> silentReplace(K key, V value) throws StoreAccessException {
        try {
            long hash = this.extractLongKey(key);
            boolean unlocked = false;
            ServerStoreProxy.ChainEntry existing = this.getProxy().lock(hash);
            try {
                Store.ValueHolder existingVal = this.resolver.resolve(existing, key, this.timeSource.getTimeMillis());
                if (existingVal != null) {
                    this.cacheLoaderWriter.write(key, value);
                    ReplaceOperation<K, V> operation = new ReplaceOperation<K, V>(key, value, this.timeSource.getTimeMillis());
                    ByteBuffer payload = this.codec.encode(operation);
                    this.storeProxy.append(hash, payload);
                    unlocked = true;
                    Store.ValueHolder valueHolder = existingVal;
                    return valueHolder;
                }
                Store.ValueHolder<V> inCache = this.loadFromLoaderWriter(key);
                if (inCache != null) {
                    this.cacheLoaderWriter.write(key, value);
                    ReplaceOperation<K, V> operation = new ReplaceOperation<K, V>(key, value, this.timeSource.getTimeMillis());
                    ByteBuffer payload = this.codec.encode(operation);
                    this.storeProxy.append(hash, payload);
                    unlocked = true;
                    Store.ValueHolder<V> valueHolder = inCache;
                    return valueHolder;
                }
                Store.ValueHolder<V> valueHolder = null;
                return valueHolder;
            }
            finally {
                this.getProxy().unlock(hash, unlocked);
            }
        }
        catch (Exception e) {
            throw StorePassThroughException.handleException((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Store.ValueHolder<V> silentRemove(K key, V value) throws StoreAccessException {
        Store.ValueHolder valueHolder;
        long hash = this.extractLongKey(key);
        boolean unlocked = false;
        ServerStoreProxy.ChainEntry existing = this.getProxy().lock(hash);
        try {
            Store.ValueHolder existingVal = this.resolver.resolve(existing, key, this.timeSource.getTimeMillis());
            if (existingVal == null) {
                existingVal = this.loadFromLoaderWriter(key);
            }
            if (existingVal != null && value.equals(existingVal.get())) {
                this.cacheLoaderWriter.delete(key);
                ConditionalRemoveOperation<K, V> operation = new ConditionalRemoveOperation<K, V>(key, value, this.timeSource.getTimeMillis());
                ByteBuffer payLoad = this.codec.encode(operation);
                this.storeProxy.append(hash, payLoad);
                unlocked = true;
            }
            valueHolder = existingVal;
        }
        catch (Throwable throwable) {
            try {
                this.getProxy().unlock(hash, unlocked);
                throw throwable;
            }
            catch (Exception e) {
                throw StorePassThroughException.handleException((Exception)e);
            }
        }
        this.getProxy().unlock(hash, unlocked);
        return valueHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Store.ValueHolder<V> silentReplace(K key, V oldValue, V newValue) throws StoreAccessException {
        Store.ValueHolder valueHolder;
        long hash = this.extractLongKey(key);
        boolean unlocked = false;
        ServerStoreProxy.ChainEntry existing = this.getProxy().lock(hash);
        try {
            Store.ValueHolder existingVal = this.resolver.resolve(existing, key, this.timeSource.getTimeMillis());
            if (existingVal == null) {
                existingVal = this.loadFromLoaderWriter(key);
            }
            if (existingVal != null && oldValue.equals(existingVal.get())) {
                this.cacheLoaderWriter.write(key, newValue);
                ConditionalReplaceOperation<K, V> operation = new ConditionalReplaceOperation<K, V>(key, oldValue, newValue, this.timeSource.getTimeMillis());
                ByteBuffer payLoad = this.codec.encode(operation);
                this.storeProxy.append(hash, payLoad);
                unlocked = true;
            }
            valueHolder = existingVal;
        }
        catch (Throwable throwable) {
            try {
                this.getProxy().unlock(hash, unlocked);
                throw throwable;
            }
            catch (Exception e) {
                throw StorePassThroughException.handleException((Exception)e);
            }
        }
        this.getProxy().unlock(hash, unlocked);
        return valueHolder;
    }

    private Store.ValueHolder<V> loadFromLoaderWriter(K key) {
        if (this.useLoaderInAtomics) {
            try {
                Object loaded = this.cacheLoaderWriter.load(key);
                if (loaded == null) {
                    return null;
                }
                return new ClusteredValueHolder<Object>(loaded);
            }
            catch (Exception e) {
                throw new StorePassThroughException((Throwable)ExceptionFactory.newCacheLoadingException((Exception)e));
            }
        }
        return null;
    }

    @ServiceDependencies(value={TimeSourceService.class, ClusteringService.class})
    public static class Provider
    extends ClusteredStore.Provider {
        @Override
        protected <K, V> ClusteredStore<K, V> createStore(Store.Configuration<K, V> storeConfig, OperationsCodec<K, V> codec, ChainResolver<K, V> resolver, TimeSource timeSource, boolean useLoaderInAtomics, Object[] serviceConfigs) {
            DefaultStoreEventDispatcher storeEventDispatcher = new DefaultStoreEventDispatcher(storeConfig.getDispatcherConcurrency());
            return new ClusteredLoaderWriterStore<K, V>(storeConfig, codec, resolver, timeSource, storeConfig.getCacheLoaderWriter(), useLoaderInAtomics, storeEventDispatcher);
        }

        @Override
        public int rank(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?, ?>> serviceConfigs) {
            int parentRank;
            block3: {
                block2: {
                    parentRank = super.rank(resourceTypes, serviceConfigs);
                    if (parentRank == 0) break block2;
                    if (!serviceConfigs.stream().noneMatch(CacheLoaderWriterConfiguration.class::isInstance)) break block3;
                }
                return 0;
            }
            return parentRank + 1;
        }

        @Override
        public int rankAuthority(ResourceType<?> authorityResource, Collection<ServiceConfiguration<?, ?>> serviceConfigs) {
            int parentRank;
            block3: {
                block2: {
                    parentRank = super.rankAuthority(authorityResource, serviceConfigs);
                    if (parentRank == 0) break block2;
                    if (!serviceConfigs.stream().noneMatch(CacheLoaderWriterConfiguration.class::isInstance)) break block3;
                }
                return 0;
            }
            return parentRank + 1;
        }
    }
}

