/*
 * Decompiled with CFR 0.152.
 */
package com.tc.entity;

import com.tc.bytes.TCByteBuffer;
import com.tc.entity.MessageCodecSupplier;
import com.tc.entity.NetworkVoltronEntityMessage;
import com.tc.entity.VoltronEntityMessage;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.ClientID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.session.SessionID;
import com.tc.object.tx.TransactionID;
import com.tc.util.Assert;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;

public class NetworkVoltronEntityMessageImpl
extends DSOMessageBase
implements NetworkVoltronEntityMessage {
    private ClientID clientID;
    private TransactionID transactionID;
    private EntityID eid;
    private EntityDescriptor entityDescriptor;
    private VoltronEntityMessage.Type type;
    private boolean requiresReplication;
    private byte[] extendedData;
    private TransactionID oldestTransactionPending;
    private MessageCodecSupplier supplier;
    private EntityMessage message;
    private Set<VoltronEntityMessage.Acks> requestedAcks;

    @Override
    public ClientID getSource() {
        Assert.assertNotNull(this.clientID);
        return this.clientID;
    }

    @Override
    public TransactionID getTransactionID() {
        Assert.assertNotNull(this.transactionID);
        return this.transactionID;
    }

    @Override
    public EntityID getEntityID() {
        return this.eid;
    }

    @Override
    public EntityDescriptor getEntityDescriptor() {
        Assert.assertNotNull(this.entityDescriptor);
        return this.entityDescriptor;
    }

    @Override
    public boolean doesRequireReplication() {
        return this.requiresReplication;
    }

    @Override
    public boolean doesRequestReceived() {
        return this.requestedAcks.contains((Object)VoltronEntityMessage.Acks.RECEIVED);
    }

    @Override
    public boolean doesRequestRetired() {
        return this.requestedAcks.contains((Object)VoltronEntityMessage.Acks.RETIRED);
    }

    @Override
    public VoltronEntityMessage.Type getVoltronType() {
        Assert.assertNotNull((Object)this.type);
        return this.type;
    }

    @Override
    public byte[] getExtendedData() {
        Assert.assertNotNull(this.extendedData);
        return this.extendedData;
    }

    @Override
    public TransactionID getOldestTransactionOnClient() {
        return this.oldestTransactionPending;
    }

    @Override
    public Set<VoltronEntityMessage.Acks> getRequestedAcks() {
        return this.requestedAcks;
    }

    @Override
    public void setContents(ClientID clientID, TransactionID transactionID, EntityID eid, EntityDescriptor entityDescriptor, VoltronEntityMessage.Type type, boolean requiresReplication, byte[] extendedData, TransactionID oldestTransactionPending, Set<VoltronEntityMessage.Acks> acks) {
        Assert.assertNull((Object)this.type);
        Assert.assertNotNull(clientID);
        Assert.assertNotNull(transactionID);
        Assert.assertNotNull(eid);
        Assert.assertNotNull(entityDescriptor);
        Assert.assertNotNull((Object)type);
        Assert.assertNotNull(extendedData);
        Assert.assertNotNull(oldestTransactionPending);
        Assert.assertNotNull(acks);
        if (type == VoltronEntityMessage.Type.INVOKE_ACTION) {
            Assert.assertTrue(entityDescriptor.isIndexed());
        } else {
            Assert.assertFalse(entityDescriptor.isIndexed());
        }
        this.clientID = clientID;
        this.transactionID = transactionID;
        this.eid = eid;
        this.entityDescriptor = entityDescriptor;
        this.type = type;
        this.requiresReplication = requiresReplication;
        this.extendedData = extendedData;
        this.oldestTransactionPending = oldestTransactionPending;
        this.requestedAcks = acks;
    }

    @Override
    public void setMessageCodecSupplier(MessageCodecSupplier supplier) {
        this.supplier = supplier;
    }

    public NetworkVoltronEntityMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public NetworkVoltronEntityMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    protected void dehydrateValues() {
        TCByteBufferOutputStream outputStream = this.getOutputStream();
        this.putNVPair((byte)0, (byte)0);
        this.clientID.serializeTo(outputStream);
        outputStream.writeLong(this.transactionID.toLong());
        this.entityDescriptor.serializeTo(outputStream);
        outputStream.writeInt(this.type.ordinal());
        outputStream.writeInt(this.extendedData.length);
        outputStream.write(this.extendedData);
        outputStream.writeBoolean(this.requiresReplication);
        outputStream.writeLong(this.oldestTransactionPending.toLong());
        outputStream.writeByte(this.requestedAcks.size());
        for (VoltronEntityMessage.Acks ack : this.requestedAcks) {
            outputStream.writeByte(ack.ordinal());
        }
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        Assert.assertTrue(0 == name);
        Assert.assertTrue(null == this.clientID);
        this.getByteValue();
        this.clientID = ClientID.readFrom(this.getInputStream());
        this.transactionID = new TransactionID(this.getLongValue());
        this.entityDescriptor = EntityDescriptor.readFrom(this.getInputStream());
        this.type = VoltronEntityMessage.Type.values()[this.getIntValue()];
        this.extendedData = this.getBytesArray();
        this.requiresReplication = this.getBooleanValue();
        this.oldestTransactionPending = new TransactionID(this.getLongValue());
        byte ac = this.getByteValue();
        if (ac == 0) {
            this.requestedAcks = EnumSet.noneOf(VoltronEntityMessage.Acks.class);
        } else {
            VoltronEntityMessage.Acks first = VoltronEntityMessage.Acks.values()[this.getByteValue()];
            if (ac > 1) {
                VoltronEntityMessage.Acks[] rest = new VoltronEntityMessage.Acks[ac - 1];
                for (int x = 0; x < ac - 1; ++x) {
                    rest[x] = VoltronEntityMessage.Acks.values()[this.getByteValue()];
                }
                this.requestedAcks = EnumSet.of(first, rest);
            } else {
                this.requestedAcks = EnumSet.of(first);
            }
        }
        try {
            if (this.type == VoltronEntityMessage.Type.INVOKE_ACTION) {
                MessageCodec<? extends EntityMessage, ? extends EntityResponse> codec = this.supplier.getMessageCodec(this.entityDescriptor);
                this.message = codec.decodeMessage(this.extendedData);
            }
        }
        catch (MessageCodecException messageCodecException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public EntityMessage getEntityMessage() {
        return this.message;
    }
}

