/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import org.ehcache.clustered.common.internal.messages.ChainCodec;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.MessageCodecUtils;
import org.ehcache.clustered.common.internal.messages.ServerStoreOpMessage;
import org.ehcache.clustered.common.internal.store.Chain;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.encoding.StructEncoder;

public class ServerStoreOpCodec {
    private static final Struct GET_AND_APPEND_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("key", 30).byteBuffer("payload", 40).build();
    private static final Struct APPEND_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("key", 30).byteBuffer("payload", 40).build();
    private static final Struct REPLACE_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("key", 30).struct("expect", 40, ChainCodec.CHAIN_STRUCT).struct("update", 50, ChainCodec.CHAIN_STRUCT).build();
    private static final Struct CLIENT_INVALIDATION_ACK_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("key", 20).int32("invalidationId", 30).build();
    private static final Struct CLIENT_INVALIDATION_ALL_ACK_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int32("invalidationId", 40).build();
    private static final Struct CLEAR_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).build();
    private static final Struct GET_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("key", 30).build();
    private static final Struct LOCK_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("hash", 30).build();
    private final MessageCodecUtils messageCodecUtils = new MessageCodecUtils();

    public byte[] encode(ServerStoreOpMessage message) {
        switch (message.getMessageType()) {
            case GET_STORE: {
                ServerStoreOpMessage.GetMessage getMessage = (ServerStoreOpMessage.GetMessage)message;
                StructEncoder<Void> encoder = GET_MESSAGE_STRUCT.encoder();
                return ((StructEncoder)((StructEncoder)encoder.enm("opCode", (Object)message.getMessageType())).int64("key", getMessage.getKey())).encode().array();
            }
            case APPEND: {
                ServerStoreOpMessage.AppendMessage appendMessage = (ServerStoreOpMessage.AppendMessage)message;
                StructEncoder<Void> encoder = APPEND_MESSAGE_STRUCT.encoder();
                this.messageCodecUtils.encodeMandatoryFields(encoder, message);
                return ((StructEncoder)((StructEncoder)encoder.int64("key", appendMessage.getKey())).byteBuffer("payload", appendMessage.getPayload())).encode().array();
            }
            case GET_AND_APPEND: {
                ServerStoreOpMessage.GetAndAppendMessage getAndAppendMessage = (ServerStoreOpMessage.GetAndAppendMessage)message;
                StructEncoder<Void> encoder = GET_AND_APPEND_MESSAGE_STRUCT.encoder();
                this.messageCodecUtils.encodeMandatoryFields(encoder, message);
                return ((StructEncoder)((StructEncoder)encoder.int64("key", getAndAppendMessage.getKey())).byteBuffer("payload", getAndAppendMessage.getPayload())).encode().array();
            }
            case REPLACE: {
                ServerStoreOpMessage.ReplaceAtHeadMessage replaceAtHeadMessage = (ServerStoreOpMessage.ReplaceAtHeadMessage)message;
                StructEncoder<Void> encoder = REPLACE_MESSAGE_STRUCT.encoder();
                this.messageCodecUtils.encodeMandatoryFields(encoder, message);
                return ((StructEncoder)encoder.int64("key", replaceAtHeadMessage.getKey())).struct("expect", replaceAtHeadMessage.getExpect(), ChainCodec::encode).struct("update", replaceAtHeadMessage.getUpdate(), ChainCodec::encode).encode().array();
            }
            case CLIENT_INVALIDATION_ACK: {
                ServerStoreOpMessage.ClientInvalidationAck clientInvalidationAckMessage = (ServerStoreOpMessage.ClientInvalidationAck)message;
                StructEncoder<Void> encoder = CLIENT_INVALIDATION_ACK_MESSAGE_STRUCT.encoder();
                return ((StructEncoder)((StructEncoder)((StructEncoder)encoder.enm("opCode", (Object)message.getMessageType())).int64("key", clientInvalidationAckMessage.getKey())).int32("invalidationId", clientInvalidationAckMessage.getInvalidationId())).encode().array();
            }
            case CLIENT_INVALIDATION_ALL_ACK: {
                ServerStoreOpMessage.ClientInvalidationAllAck clientInvalidationAllAckMessage = (ServerStoreOpMessage.ClientInvalidationAllAck)message;
                StructEncoder<Void> encoder = CLIENT_INVALIDATION_ALL_ACK_MESSAGE_STRUCT.encoder();
                return ((StructEncoder)((StructEncoder)encoder.enm("opCode", (Object)message.getMessageType())).int32("invalidationId", clientInvalidationAllAckMessage.getInvalidationId())).encode().array();
            }
            case CLEAR: {
                StructEncoder<Void> encoder = CLEAR_MESSAGE_STRUCT.encoder();
                this.messageCodecUtils.encodeMandatoryFields(encoder, message);
                return encoder.encode().array();
            }
            case LOCK: {
                StructEncoder<Void> encoder = LOCK_STRUCT.encoder();
                return ((StructEncoder)((StructEncoder)encoder.enm("opCode", (Object)message.getMessageType())).int64("hash", ((ServerStoreOpMessage.LockMessage)message).getHash())).encode().array();
            }
            case UNLOCK: {
                StructEncoder<Void> encoder = LOCK_STRUCT.encoder();
                return ((StructEncoder)((StructEncoder)encoder.enm("opCode", (Object)message.getMessageType())).int64("hash", ((ServerStoreOpMessage.UnlockMessage)message).getHash())).encode().array();
            }
        }
        throw new RuntimeException("Unhandled message operation : " + (Object)((Object)message.getMessageType()));
    }

    public EhcacheEntityMessage decode(EhcacheMessageType opCode, ByteBuffer messageBuffer) {
        switch (opCode) {
            case GET_STORE: {
                StructDecoder<Void> decoder = GET_MESSAGE_STRUCT.decoder(messageBuffer);
                Long key = decoder.int64("key");
                return new ServerStoreOpMessage.GetMessage(key);
            }
            case GET_AND_APPEND: {
                StructDecoder<Void> decoder = GET_AND_APPEND_MESSAGE_STRUCT.decoder(messageBuffer);
                Long key = decoder.int64("key");
                ByteBuffer payload = decoder.byteBuffer("payload");
                return new ServerStoreOpMessage.GetAndAppendMessage(key, payload);
            }
            case APPEND: {
                StructDecoder<Void> decoder = APPEND_MESSAGE_STRUCT.decoder(messageBuffer);
                Long key = decoder.int64("key");
                ByteBuffer payload = decoder.byteBuffer("payload");
                return new ServerStoreOpMessage.AppendMessage(key, payload);
            }
            case REPLACE: {
                StructDecoder<Void> decoder = REPLACE_MESSAGE_STRUCT.decoder(messageBuffer);
                Long key = decoder.int64("key");
                Chain expect = ChainCodec.decode(decoder.struct("expect"));
                Chain update = ChainCodec.decode(decoder.struct("update"));
                return new ServerStoreOpMessage.ReplaceAtHeadMessage(key, expect, update);
            }
            case CLIENT_INVALIDATION_ACK: {
                StructDecoder<Void> decoder = CLIENT_INVALIDATION_ACK_MESSAGE_STRUCT.decoder(messageBuffer);
                Long key = decoder.int64("key");
                Integer invalidationId = decoder.int32("invalidationId");
                return new ServerStoreOpMessage.ClientInvalidationAck(key, invalidationId);
            }
            case CLIENT_INVALIDATION_ALL_ACK: {
                StructDecoder<Void> decoder = CLIENT_INVALIDATION_ALL_ACK_MESSAGE_STRUCT.decoder(messageBuffer);
                Integer invalidationId = decoder.int32("invalidationId");
                return new ServerStoreOpMessage.ClientInvalidationAllAck(invalidationId);
            }
            case CLEAR: {
                return new ServerStoreOpMessage.ClearMessage();
            }
            case LOCK: {
                StructDecoder<Void> decoder = LOCK_STRUCT.decoder(messageBuffer);
                long hash = decoder.int64("hash");
                return new ServerStoreOpMessage.LockMessage(hash);
            }
            case UNLOCK: {
                StructDecoder<Void> decoder = LOCK_STRUCT.decoder(messageBuffer);
                long hash = decoder.int64("hash");
                return new ServerStoreOpMessage.UnlockMessage(hash);
            }
        }
        throw new RuntimeException("Unhandled message operation : " + (Object)((Object)opCode));
    }
}

