/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.bytes.TCByteBuffer;
import com.tc.net.TCSocketAddress;
import com.tc.net.core.TCConnection;
import com.tc.net.core.event.TCConnectionErrorEvent;
import com.tc.net.core.event.TCConnectionEvent;
import com.tc.net.core.event.TCConnectionEventListener;
import com.tc.net.protocol.IllegalReconnectException;
import com.tc.net.protocol.NetworkLayer;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.transport.AbstractMessageTransport;
import com.tc.net.protocol.transport.ConnectionHealthCheckerContext;
import com.tc.net.protocol.transport.ConnectionHealthCheckerContextDummyImpl;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.HealthCheckerProbeMessage;
import com.tc.net.protocol.transport.JvmIDUtil;
import com.tc.net.protocol.transport.MessageTransportState;
import com.tc.net.protocol.transport.MessageTransportStatus;
import com.tc.net.protocol.transport.TransportHandshakeErrorContext;
import com.tc.net.protocol.transport.TransportHandshakeErrorHandler;
import com.tc.net.protocol.transport.TransportHandshakeMessageFactory;
import com.tc.net.protocol.transport.WireProtocolMessage;
import com.tc.util.Assert;
import com.tc.util.ProductID;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

abstract class MessageTransportBase
extends AbstractMessageTransport
implements TCConnectionEventListener {
    private TCConnection connection;
    private ConnectionID connectionId = new ConnectionID(JvmIDUtil.getJvmID(), ChannelID.NULL_ID.toLong());
    protected final MessageTransportStatus status;
    protected final TransportHandshakeMessageFactory messageFactory;
    private final TransportHandshakeErrorHandler handshakeErrorHandler;
    private NetworkLayer receiveLayer;
    private final Object attachingNewConnection = new Object();
    private final AtomicReference<TCConnectionEvent> connectionCloseEvent = new AtomicReference<Object>(null);
    private boolean allowConnectionReplace = false;
    private volatile ConnectionHealthCheckerContext healthCheckerContext = new ConnectionHealthCheckerContextDummyImpl();
    private int remoteCallbackPort = -1;

    protected MessageTransportBase(MessageTransportState initialState, TransportHandshakeErrorHandler handshakeErrorHandler, TransportHandshakeMessageFactory messageFactory, Logger logger) {
        super(logger);
        this.handshakeErrorHandler = handshakeErrorHandler;
        this.messageFactory = messageFactory;
        this.status = new MessageTransportStatus(initialState, logger);
    }

    @Override
    public void setAllowConnectionReplace(boolean allow) {
        this.allowConnectionReplace = allow;
    }

    public synchronized void setHealthCheckerContext(ConnectionHealthCheckerContext context) {
        this.healthCheckerContext = context;
    }

    public synchronized ConnectionHealthCheckerContext getHealthCheckerContext() {
        return this.healthCheckerContext;
    }

    @Override
    public final ConnectionID getConnectionID() {
        return this.connectionId;
    }

    @Override
    public ProductID getProductID() {
        return this.connectionId.getProductId();
    }

    @Override
    public final void setReceiveLayer(NetworkLayer layer) {
        this.receiveLayer = layer;
    }

    @Override
    public final NetworkLayer getReceiveLayer() {
        return this.receiveLayer;
    }

    @Override
    public final void setSendLayer(NetworkLayer layer) {
        throw new UnsupportedOperationException("Transport layer has no send layer.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void receiveTransportMessage(WireProtocolMessage message) {
        Object object = this.attachingNewConnection;
        synchronized (object) {
            if (message.getSource() == this.connection) {
                this.receiveTransportMessageImpl(message);
            } else {
                this.getLogger().warn("Received message from an old connection: " + message.getSource() + "; " + message);
            }
        }
    }

    protected abstract void receiveTransportMessageImpl(WireProtocolMessage var1);

    protected final void receiveToReceiveLayer(WireProtocolMessage message) {
        Assert.assertNotNull(this.receiveLayer);
        if (message.getMessageProtocol() == 2) {
            this.getLogger().info(message.toString());
            throw new AssertionError((Object)("Wrong handshake message from: " + message.getSource()));
        }
        if (message.getMessageProtocol() == 4) {
            if (this.healthCheckerContext.receiveProbe((HealthCheckerProbeMessage)message)) {
                return;
            }
            throw new AssertionError((Object)("Wrong HealthChecker Probe message from: " + message.getSource()));
        }
        this.receiveLayer.receive(message.getPayload());
        message.getWireProtocolHeader().recycle();
    }

    @Override
    public final void receive(TCByteBuffer[] msgData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.terminate(false);
    }

    public void disconnect() {
        this.terminate(true);
    }

    protected boolean resetIfNotEnd() {
        return this.status.resetIfNotEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminate(boolean disconnect) {
        MessageTransportStatus messageTransportStatus = this.status;
        synchronized (messageTransportStatus) {
            if (this.status.isEnd()) {
                this.getLogger().debug("Can only close an open connection");
                return;
            }
            if (disconnect) {
                this.status.disconnect();
            } else {
                this.status.end();
            }
        }
        if (!disconnect) {
            this.fireTransportClosedEvent();
        }
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.asynchClose();
        }
        if (this.healthCheckerContext != null) {
            this.healthCheckerContext.close();
        }
    }

    @Override
    public final void send(TCNetworkMessage message) throws IOException {
        if (!this.status.isEstablished()) {
            throw new IOException("connection not established");
        }
        this.sendToConnection(message);
    }

    @Override
    public void sendToConnection(TCNetworkMessage message) throws IOException {
        if (message == null) {
            throw new AssertionError((Object)"Attempt to send a null message.");
        }
        if (this.status.isClosed()) {
            throw new IOException("Couldn't send message status: " + this.status);
        }
        this.connection.putMessage(message);
    }

    @Override
    public boolean isConnected() {
        TCConnection conn = this.getConnection();
        return conn != null && conn.isConnected() && conn.isTransportEstablished() && !conn.isClosed() && !conn.isClosePending();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void attachNewConnection(TCConnection newConnection) throws IllegalReconnectException {
        Object object = this.attachingNewConnection;
        synchronized (object) {
            if (this.connection != null && !this.allowConnectionReplace) {
                throw new IllegalReconnectException();
            }
            this.getConnectionAttacher().attachNewConnection(this.connectionCloseEvent.get(), this.connection, newConnection);
        }
    }

    protected ConnectionAttacher getConnectionAttacher() {
        return new DefaultConnectionAttacher(this, this.getLogger());
    }

    @Override
    public void connectEvent(TCConnectionEvent event) {
        this.status.connected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeEvent(TCConnectionEvent event) {
        boolean isSameConnection = false;
        Object object = this.attachingNewConnection;
        synchronized (object) {
            TCConnection src = event.getSource();
            boolean bl = isSameConnection = src == this.connection;
            if (isSameConnection) {
                this.connectionCloseEvent.set(event);
            }
        }
        if (isSameConnection) {
            boolean forcedDisconnect = false;
            MessageTransportStatus messageTransportStatus = this.status;
            synchronized (messageTransportStatus) {
                this.getLogger().debug("CLOSE EVENT : " + this.connection + ". STATUS : " + this.status);
                if (this.status.isEnd()) {
                    return;
                }
                if (this.status.isConnected() || this.status.isEstablished() || this.status.isDisconnected()) {
                    if (this.status.isDisconnected()) {
                        forcedDisconnect = true;
                    }
                } else {
                    this.status.reset();
                    this.getLogger().debug("closing down connection - " + event + " - " + this.status);
                    return;
                }
                this.status.reset();
            }
            if (forcedDisconnect) {
                this.fireTransportForcedDisconnectEvent();
            } else {
                this.fireTransportDisconnectedEvent();
            }
        } else {
            this.getLogger().debug("NOT SAME CONNECTION");
        }
    }

    @Override
    public void errorEvent(TCConnectionErrorEvent errorEvent) {
    }

    @Override
    public void endOfFileEvent(TCConnectionEvent event) {
    }

    protected void handleHandshakeError(TransportHandshakeErrorContext e) {
        this.handshakeErrorHandler.handleHandshakeError(e);
    }

    protected TCConnection getConnection() {
        return this.connection;
    }

    @Override
    public TCSocketAddress getRemoteAddress() {
        return this.connection != null ? this.connection.getRemoteAddress() : null;
    }

    @Override
    public TCSocketAddress getLocalAddress() {
        return this.connection != null ? this.connection.getLocalAddress() : null;
    }

    protected void setConnection(TCConnection conn) {
        TCConnection old = this.connection;
        this.connection = conn;
        this.connection.addListener(this);
        if (old != null) {
            old.removeListener(this);
        }
    }

    protected void clearConnection() {
        TCConnection conn = this.getConnection();
        if (conn != null) {
            conn.close(10000L);
            this.connectionId = new ConnectionID(JvmIDUtil.getJvmID(), ChannelID.NULL_ID.toLong());
            conn.removeListener(this);
            this.connection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean wireNewConnection(TCConnection conn) {
        MessageTransportStatus messageTransportStatus = this.status;
        synchronized (messageTransportStatus) {
            if (this.status.isClosed()) {
                this.getLogger().warn("Connection stack is already closed. " + this.status + "; Conn: " + conn);
                conn.removeListener(this);
                conn.asynchClose();
                return false;
            }
            this.setConnection(conn);
            this.status.reset();
            if (conn.isConnected()) {
                this.status.connected();
            }
            return true;
        }
    }

    @Override
    public short getStackLayerFlag() {
        return 1;
    }

    @Override
    public String getStackLayerName() {
        return "Transport Layer";
    }

    @Override
    public synchronized int getRemoteCallbackPort() {
        return this.remoteCallbackPort;
    }

    @Override
    public synchronized void setRemoteCallbackPort(int remoteCallbackPort) {
        this.remoteCallbackPort = remoteCallbackPort;
    }

    @Override
    public final void initConnectionID(ConnectionID cid) {
        this.connectionId = cid;
    }

    void log(String msg) {
        if (!this.getProductID().isInternal()) {
            this.getLogger().info(msg);
        } else {
            this.getLogger().debug(msg);
        }
    }

    @Override
    public Map<String, ?> getStateMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("connection", this.getConnection().getState());
        map.put("id", this.connectionId.toString());
        return map;
    }

    private static final class DefaultConnectionAttacher
    implements ConnectionAttacher {
        private final MessageTransportBase transport;
        private final Logger logger;

        private DefaultConnectionAttacher(MessageTransportBase transport, Logger logger) {
            this.transport = transport;
            this.logger = logger;
        }

        @Override
        public void attachNewConnection(TCConnectionEvent closeEvent, TCConnection oldConnection, TCConnection newConnection) {
            Assert.assertNotNull(oldConnection);
            if (closeEvent == null || closeEvent.getSource() != oldConnection) {
                if (this.transport.isConnected()) {
                    this.transport.status.reset();
                    this.transport.fireTransportDisconnectedEvent();
                    this.transport.getConnection().asynchClose();
                } else {
                    this.logger.warn("Old connection " + oldConnection + "might not have been Transport Established ");
                }
            }
            if (oldConnection != null && oldConnection != this.transport.getConnection()) {
                oldConnection.removeListener(this.transport);
            }
            this.transport.wireNewConnection(newConnection);
        }
    }

    protected static interface ConnectionAttacher {
        public void attachNewConnection(TCConnectionEvent var1, TCConnection var2, TCConnection var3);
    }
}

