/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.loaderwriter;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.ehcache.clustered.client.internal.store.ClusteredStore;
import org.ehcache.clustered.client.internal.store.ClusteredValueHolder;
import org.ehcache.clustered.client.internal.store.ResolvedChain;
import org.ehcache.clustered.client.internal.store.ServerStoreProxy;
import org.ehcache.clustered.client.internal.store.lock.LockManager;
import org.ehcache.clustered.client.internal.store.operations.ChainResolver;
import org.ehcache.clustered.client.internal.store.operations.EternalChainResolver;
import org.ehcache.clustered.client.service.ClusteringService;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.operations.ConditionalRemoveOperation;
import org.ehcache.clustered.common.internal.store.operations.ConditionalReplaceOperation;
import org.ehcache.clustered.common.internal.store.operations.PutIfAbsentOperation;
import org.ehcache.clustered.common.internal.store.operations.PutOperation;
import org.ehcache.clustered.common.internal.store.operations.RemoveOperation;
import org.ehcache.clustered.common.internal.store.operations.ReplaceOperation;
import org.ehcache.clustered.common.internal.store.operations.Result;
import org.ehcache.clustered.common.internal.store.operations.codecs.OperationsCodec;
import org.ehcache.config.ResourceType;
import org.ehcache.core.exceptions.ExceptionFactory;
import org.ehcache.core.exceptions.StorePassThroughException;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.tiering.AuthoritativeTier;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.core.spi.time.TimeSourceService;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.loaderwriter.CacheLoaderWriterConfiguration;
import org.ehcache.spi.loaderwriter.CacheLoadingException;
import org.ehcache.spi.resilience.StoreAccessException;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;

public class ClusteredLoaderWriterStore<K, V>
extends ClusteredStore<K, V>
implements AuthoritativeTier<K, V> {
    private final CacheLoaderWriter<? super K, V> cacheLoaderWriter;
    private final boolean useLoaderInAtomics;

    public ClusteredLoaderWriterStore(Store.Configuration<K, V> config, OperationsCodec<K, V> codec, ChainResolver<K, V> resolver, TimeSource timeSource, CacheLoaderWriter<? super K, V> loaderWriter, boolean useLoaderInAtomics) {
        super(config, codec, resolver, timeSource);
        this.cacheLoaderWriter = loaderWriter;
        this.useLoaderInAtomics = useLoaderInAtomics;
    }

    ClusteredLoaderWriterStore(Store.Configuration<K, V> config, OperationsCodec<K, V> codec, EternalChainResolver<K, V> resolver, ServerStoreProxy proxy, TimeSource timeSource, CacheLoaderWriter<? super K, V> loaderWriter) {
        super(config, codec, resolver, proxy, timeSource);
        this.cacheLoaderWriter = loaderWriter;
        this.useLoaderInAtomics = true;
    }

    private LockManager getProxy() {
        return (LockManager)((Object)this.storeProxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Store.ValueHolder<V> getInternal(K key) throws StoreAccessException, TimeoutException {
        Store.ValueHolder holder = super.getInternal(key);
        try {
            if (holder != null) return holder;
            long hash = this.extractLongKey(key);
            boolean unlocked = false;
            this.getProxy().lock(hash);
            try {
                Object value = null;
                try {
                    value = this.cacheLoaderWriter.load(key);
                }
                catch (Exception e) {
                    throw new StorePassThroughException((Throwable)new CacheLoadingException((Throwable)e));
                }
                if (value == null) {
                    Store.ValueHolder<V> valueHolder = null;
                    return valueHolder;
                }
                this.append(key, value);
                unlocked = true;
                ClusteredValueHolder<Object> clusteredValueHolder = new ClusteredValueHolder<Object>(value);
                return clusteredValueHolder;
            }
            finally {
                if (!unlocked) {
                    this.getProxy().unlock(hash);
                }
            }
        }
        catch (RuntimeException re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    private void append(K key, V value) throws TimeoutException {
        PutOperation<K, V> operation = new PutOperation<K, V>(key, value, this.timeSource.getTimeMillis());
        ByteBuffer payload = this.codec.encode(operation);
        long extractedKey = this.extractLongKey(key);
        this.storeProxy.append(extractedKey, payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Store.PutStatus silentPut(K key, V value) throws StoreAccessException {
        try {
            long hash = this.extractLongKey(key);
            boolean unlocked = false;
            this.getProxy().lock(hash);
            try {
                this.cacheLoaderWriter.write(key, value);
                this.append(key, value);
                unlocked = true;
            }
            finally {
                if (!unlocked) {
                    this.getProxy().unlock(hash);
                }
            }
            return Store.PutStatus.PUT;
        }
        catch (Exception e) {
            throw StorePassThroughException.handleException((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean silentRemove(K key) throws StoreAccessException {
        try {
            long hash = this.extractLongKey(key);
            boolean unlocked = false;
            RemoveOperation operation = new RemoveOperation(key, this.timeSource.getTimeMillis());
            ByteBuffer payLoad = this.codec.encode(operation);
            Chain chain = this.getProxy().lock(hash);
            try {
                this.cacheLoaderWriter.delete(key);
                this.storeProxy.append(hash, payLoad);
                unlocked = true;
                ResolvedChain resolvedChain = this.resolver.resolve(chain, key, this.timeSource.getTimeMillis());
                if (resolvedChain.getResolvedResult(key) != null) {
                    boolean bl2 = true;
                    return bl2;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (!unlocked) {
                    this.getProxy().unlock(hash);
                }
            }
        }
        catch (Exception e) {
            throw StorePassThroughException.handleException((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected V silentPutIfAbsent(K key, V value) throws StoreAccessException {
        try {
            long hash = this.extractLongKey(key);
            boolean unlocked = false;
            Chain existing = this.getProxy().lock(hash);
            try {
                V existingVal;
                ResolvedChain resolvedChain = this.resolver.resolve(existing, key, this.timeSource.getTimeMillis());
                Result result = resolvedChain.getResolvedResult(key);
                V v = existingVal = result == null ? null : (V)result.getValue();
                if (existingVal != null) {
                    V v2 = existingVal;
                    return v2;
                }
                existingVal = this.loadFromLoaderWriter(key);
                if (existingVal == null) {
                    this.cacheLoaderWriter.write(key, value);
                    PutIfAbsentOperation<K, V> operation = new PutIfAbsentOperation<K, V>(key, value, this.timeSource.getTimeMillis());
                    ByteBuffer payload = this.codec.encode(operation);
                    this.storeProxy.append(hash, payload);
                    unlocked = true;
                }
                V v3 = existingVal;
                return v3;
            }
            finally {
                if (!unlocked) {
                    this.getProxy().unlock(hash);
                }
            }
        }
        catch (Exception e) {
            throw StorePassThroughException.handleException((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected V silentReplace(K key, V value) throws StoreAccessException {
        try {
            long hash = this.extractLongKey(key);
            boolean unlocked = false;
            Chain existing = this.getProxy().lock(hash);
            try {
                V existingVal;
                ResolvedChain resolvedChain = this.resolver.resolve(existing, key, this.timeSource.getTimeMillis());
                Result result = resolvedChain.getResolvedResult(key);
                V v = existingVal = result == null ? null : (V)result.getValue();
                if (existingVal != null) {
                    this.cacheLoaderWriter.write(key, value);
                    ReplaceOperation<K, V> operation = new ReplaceOperation<K, V>(key, value, this.timeSource.getTimeMillis());
                    ByteBuffer payload = this.codec.encode(operation);
                    this.storeProxy.append(hash, payload);
                    unlocked = true;
                    V v2 = existingVal;
                    return v2;
                }
                V inCache = this.loadFromLoaderWriter(key);
                if (inCache != null) {
                    this.cacheLoaderWriter.write(key, value);
                    ReplaceOperation<K, V> operation = new ReplaceOperation<K, V>(key, value, this.timeSource.getTimeMillis());
                    ByteBuffer payload = this.codec.encode(operation);
                    this.storeProxy.append(hash, payload);
                    unlocked = true;
                    V v3 = inCache;
                    return v3;
                }
                V v4 = null;
                return v4;
            }
            finally {
                if (!unlocked) {
                    this.getProxy().unlock(hash);
                }
            }
        }
        catch (Exception e) {
            throw StorePassThroughException.handleException((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected V silentRemove(K key, V value) throws StoreAccessException {
        try {
            long hash = this.extractLongKey(key);
            boolean unlocked = false;
            Chain existing = this.getProxy().lock(hash);
            try {
                V existingVal;
                ResolvedChain resolvedChain = this.resolver.resolve(existing, key, this.timeSource.getTimeMillis());
                Result result = resolvedChain.getResolvedResult(key);
                V v = existingVal = result == null ? null : (V)result.getValue();
                if (existingVal == null) {
                    existingVal = this.loadFromLoaderWriter(key);
                }
                if (value.equals(existingVal)) {
                    this.cacheLoaderWriter.delete(key);
                    ConditionalRemoveOperation<K, Object> operation = new ConditionalRemoveOperation<K, Object>(key, value, this.timeSource.getTimeMillis());
                    ByteBuffer payLoad = this.codec.encode(operation);
                    this.storeProxy.append(hash, payLoad);
                    unlocked = true;
                }
                V v2 = existingVal;
                return v2;
            }
            finally {
                if (!unlocked) {
                    this.getProxy().unlock(hash);
                }
            }
        }
        catch (Exception e) {
            throw StorePassThroughException.handleException((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected V silentReplace(K key, V oldValue, V newValue) throws StoreAccessException {
        try {
            long hash = this.extractLongKey(key);
            boolean unlocked = false;
            Chain existing = this.getProxy().lock(hash);
            try {
                V existingVal;
                ResolvedChain resolvedChain = this.resolver.resolve(existing, key, this.timeSource.getTimeMillis());
                Result result = resolvedChain.getResolvedResult(key);
                V v = existingVal = result == null ? null : (V)result.getValue();
                if (existingVal == null) {
                    existingVal = this.loadFromLoaderWriter(key);
                }
                if (oldValue.equals(existingVal)) {
                    this.cacheLoaderWriter.write(key, newValue);
                    ConditionalReplaceOperation<K, Object> operation = new ConditionalReplaceOperation<K, Object>(key, oldValue, newValue, this.timeSource.getTimeMillis());
                    ByteBuffer payLoad = this.codec.encode(operation);
                    this.storeProxy.append(hash, payLoad);
                    unlocked = true;
                }
                V v2 = existingVal;
                return v2;
            }
            finally {
                if (!unlocked) {
                    this.getProxy().unlock(hash);
                }
            }
        }
        catch (Exception e) {
            throw StorePassThroughException.handleException((Exception)e);
        }
    }

    private V loadFromLoaderWriter(K key) {
        if (this.useLoaderInAtomics) {
            try {
                return (V)this.cacheLoaderWriter.load(key);
            }
            catch (Exception e) {
                throw new StorePassThroughException((Throwable)ExceptionFactory.newCacheLoadingException((Exception)e));
            }
        }
        return null;
    }

    @ServiceDependencies(value={TimeSourceService.class, ClusteringService.class})
    public static class Provider
    extends ClusteredStore.Provider {
        @Override
        protected <K, V> ClusteredStore<K, V> createStore(Store.Configuration<K, V> storeConfig, OperationsCodec<K, V> codec, ChainResolver<K, V> resolver, TimeSource timeSource, boolean useLoaderInAtomics, Object[] serviceConfigs) {
            return new ClusteredLoaderWriterStore<K, V>(storeConfig, codec, resolver, timeSource, storeConfig.getCacheLoaderWriter(), useLoaderInAtomics);
        }

        @Override
        public int rank(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?>> serviceConfigs) {
            int parentRank;
            block3: {
                block2: {
                    parentRank = super.rank(resourceTypes, serviceConfigs);
                    if (parentRank == 0) break block2;
                    if (!serviceConfigs.stream().noneMatch(CacheLoaderWriterConfiguration.class::isInstance)) break block3;
                }
                return 0;
            }
            return parentRank + 1;
        }

        @Override
        public int rankAuthority(ResourceType<?> authorityResource, Collection<ServiceConfiguration<?>> serviceConfigs) {
            int parentRank;
            block3: {
                block2: {
                    parentRank = super.rankAuthority(authorityResource, serviceConfigs);
                    if (parentRank == 0) break block2;
                    if (!serviceConfigs.stream().noneMatch(CacheLoaderWriterConfiguration.class::isInstance)) break block3;
                }
                return 0;
            }
            return parentRank + 1;
        }
    }
}

