/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import org.ehcache.clustered.common.internal.messages.ConcurrentEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.EhcacheOperationMessage;
import org.ehcache.clustered.common.internal.store.Chain;

public abstract class ServerStoreOpMessage
extends EhcacheOperationMessage {
    private ServerStoreOpMessage() {
    }

    public static class UnlockMessage
    extends ServerStoreOpMessage {
        private final long hash;

        public UnlockMessage(long hash) {
            this.hash = hash;
        }

        public long getHash() {
            return this.hash;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.UNLOCK;
        }
    }

    public static class LockMessage
    extends ServerStoreOpMessage {
        private final long hash;

        public LockMessage(long hash) {
            this.hash = hash;
        }

        public long getHash() {
            return this.hash;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.LOCK;
        }
    }

    public static class ClearMessage
    extends ServerStoreOpMessage {
        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.CLEAR;
        }
    }

    public static class ClientInvalidationAllAck
    extends ServerStoreOpMessage {
        private final int invalidationId;

        public ClientInvalidationAllAck(int invalidationId) {
            this.invalidationId = invalidationId;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.CLIENT_INVALIDATION_ALL_ACK;
        }

        public int getInvalidationId() {
            return this.invalidationId;
        }
    }

    public static class ClientInvalidationAck
    extends KeyBasedServerStoreOpMessage {
        private final int invalidationId;

        public ClientInvalidationAck(long key, int invalidationId) {
            super(key);
            this.invalidationId = invalidationId;
        }

        public int getInvalidationId() {
            return this.invalidationId;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.CLIENT_INVALIDATION_ACK;
        }
    }

    public static class ReplaceAtHeadMessage
    extends KeyBasedServerStoreOpMessage {
        private final Chain expect;
        private final Chain update;

        public ReplaceAtHeadMessage(long key, Chain expect, Chain update) {
            super(key);
            this.expect = expect;
            this.update = update;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.REPLACE;
        }

        public Chain getExpect() {
            return this.expect;
        }

        public Chain getUpdate() {
            return this.update;
        }
    }

    public static class AppendMessage
    extends KeyBasedServerStoreOpMessage {
        private final ByteBuffer payload;

        public AppendMessage(long key, ByteBuffer payload) {
            super(key);
            this.payload = payload;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.APPEND;
        }

        public ByteBuffer getPayload() {
            return this.payload;
        }
    }

    public static class GetAndAppendMessage
    extends KeyBasedServerStoreOpMessage {
        private final ByteBuffer payload;

        public GetAndAppendMessage(long key, ByteBuffer payload) {
            super(key);
            this.payload = payload;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.GET_AND_APPEND;
        }

        public ByteBuffer getPayload() {
            return this.payload;
        }
    }

    public static class GetMessage
    extends KeyBasedServerStoreOpMessage {
        public GetMessage(long key) {
            super(key);
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.GET_STORE;
        }
    }

    public static abstract class KeyBasedServerStoreOpMessage
    extends ServerStoreOpMessage
    implements ConcurrentEntityMessage {
        private final long key;

        KeyBasedServerStoreOpMessage(long key) {
            this.key = key;
        }

        public long getKey() {
            return this.key;
        }

        @Override
        public long concurrencyKey() {
            return this.key;
        }
    }
}

