/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.service;

import java.io.Serializable;
import java.util.function.Predicate;
import org.ehcache.clustered.client.internal.service.ClusteredStateHolder;
import org.ehcache.clustered.client.internal.store.ClusterTierClientEntity;
import org.ehcache.clustered.client.service.ClusteringService;
import org.ehcache.spi.persistence.StateHolder;
import org.ehcache.spi.persistence.StateRepository;

class ClusterStateRepository
implements StateRepository {
    private final ClusteringService.ClusteredCacheIdentifier clusterCacheIdentifier;
    private final ClusterTierClientEntity clientEntity;
    private final String composedId;

    ClusterStateRepository(ClusteringService.ClusteredCacheIdentifier clusterCacheIdentifier, String id, ClusterTierClientEntity clientEntity) {
        this.clusterCacheIdentifier = clusterCacheIdentifier;
        this.composedId = clusterCacheIdentifier.getId() + "-" + id;
        this.clientEntity = clientEntity;
    }

    @Override
    public <K extends Serializable, V extends Serializable> StateHolder<K, V> getPersistentStateHolder(String name, Class<K> keyClass, Class<V> valueClass, Predicate<Class<?>> isClassPermitted, ClassLoader classLoader) {
        return new ClusteredStateHolder<K, V>(this.clusterCacheIdentifier.getId(), this.composedId + "-" + name, this.clientEntity, keyClass, valueClass, isClassPermitted, classLoader);
    }
}

