/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.loaderwriter.writebehind;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import org.ehcache.clustered.client.internal.loaderwriter.ClusteredLoaderWriterStore;
import org.ehcache.clustered.client.internal.loaderwriter.writebehind.ClusteredWriteBehind;
import org.ehcache.clustered.client.internal.store.ClusteredStore;
import org.ehcache.clustered.client.internal.store.ClusteredValueHolder;
import org.ehcache.clustered.client.internal.store.ResolvedChain;
import org.ehcache.clustered.client.internal.store.ServerStoreProxy;
import org.ehcache.clustered.client.internal.store.lock.LockManager;
import org.ehcache.clustered.client.internal.store.operations.ChainResolver;
import org.ehcache.clustered.client.service.ClusteringService;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.operations.ConditionalRemoveOperation;
import org.ehcache.clustered.common.internal.store.operations.ConditionalReplaceOperation;
import org.ehcache.clustered.common.internal.store.operations.PutIfAbsentOperation;
import org.ehcache.clustered.common.internal.store.operations.PutOperation;
import org.ehcache.clustered.common.internal.store.operations.PutWithWriterOperation;
import org.ehcache.clustered.common.internal.store.operations.RemoveOperation;
import org.ehcache.clustered.common.internal.store.operations.ReplaceOperation;
import org.ehcache.clustered.common.internal.store.operations.Result;
import org.ehcache.clustered.common.internal.store.operations.codecs.OperationsCodec;
import org.ehcache.config.ResourceType;
import org.ehcache.core.exceptions.StorePassThroughException;
import org.ehcache.core.spi.service.ServiceUtils;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.tiering.AuthoritativeTier;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.core.spi.time.TimeSourceService;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.loaderwriter.WriteBehindConfiguration;
import org.ehcache.spi.resilience.StoreAccessException;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;

public class ClusteredWriteBehindStore<K, V>
extends ClusteredStore<K, V>
implements AuthoritativeTier<K, V> {
    private final CacheLoaderWriter<? super K, V> cacheLoaderWriter;
    private final ClusteredWriteBehind<K, V> clusteredWriteBehind;

    private ClusteredWriteBehindStore(Store.Configuration<K, V> config, OperationsCodec<K, V> codec, ChainResolver<K, V> resolver, TimeSource timeSource, CacheLoaderWriter<? super K, V> loaderWriter, ExecutorService executorService) {
        super(config, codec, resolver, timeSource);
        this.cacheLoaderWriter = loaderWriter;
        this.clusteredWriteBehind = new ClusteredWriteBehind<K, V>(this, executorService, timeSource, resolver, this.cacheLoaderWriter, codec);
    }

    Chain lock(long hash) throws TimeoutException {
        return ((LockManager)((Object)this.storeProxy)).lock(hash);
    }

    void unlock(long hash) throws TimeoutException {
        ((LockManager)((Object)this.storeProxy)).unlock(hash);
    }

    void replaceAtHead(long key, Chain expected, Chain replacement) {
        this.storeProxy.replaceAtHead(key, expected, replacement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Store.ValueHolder<V> getInternal(K key) throws StoreAccessException, TimeoutException {
        try {
            Chain chain = this.storeProxy.get(this.extractLongKey(key));
            if (!chain.isEmpty()) {
                ClusteredValueHolder holder = null;
                ResolvedChain resolvedChain = this.resolver.resolve(chain, key, this.timeSource.getTimeMillis());
                Result resolvedResult = resolvedChain.getResolvedResult(key);
                if (resolvedResult == null) return holder;
                Object value2 = resolvedResult.getValue();
                long expirationTime = resolvedChain.getExpirationTime();
                if (expirationTime != Long.MAX_VALUE) return new ClusteredValueHolder(value2, expirationTime);
                return new ClusteredValueHolder(value2);
            }
            long hash = this.extractLongKey(key);
            this.lock(hash);
            try {
                V value;
                try {
                    value = this.cacheLoaderWriter.load(key);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (value == null) {
                    Store.ValueHolder<V> valueHolder = null;
                    return valueHolder;
                }
                this.append(key, value);
                ClusteredValueHolder<V> clusteredValueHolder = new ClusteredValueHolder<V>(value);
                return clusteredValueHolder;
            }
            finally {
                this.unlock(hash);
            }
        }
        catch (RuntimeException re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    private void append(K key, V value) throws TimeoutException {
        PutOperation<K, V> operation = new PutOperation<K, V>(key, value, this.timeSource.getTimeMillis());
        ByteBuffer payload = this.codec.encode(operation);
        long extractedKey = this.extractLongKey(key);
        this.storeProxy.append(extractedKey, payload);
    }

    @Override
    protected Store.PutStatus silentPut(K key, V value) throws StoreAccessException {
        try {
            PutWithWriterOperation<K, V> operation = new PutWithWriterOperation<K, V>(key, value, this.timeSource.getTimeMillis());
            ByteBuffer payload = this.codec.encode(operation);
            long extractedKey = this.extractLongKey(key);
            this.storeProxy.append(extractedKey, payload);
            return Store.PutStatus.PUT;
        }
        catch (Exception re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    @Override
    protected V silentPutIfAbsent(K key, V value) throws StoreAccessException {
        try {
            PutIfAbsentOperation<K, V> operation = new PutIfAbsentOperation<K, V>(key, value, this.timeSource.getTimeMillis());
            ByteBuffer payload = this.codec.encode(operation);
            long extractedKey = this.extractLongKey(key);
            Chain chain = this.storeProxy.getAndAppend(extractedKey, payload);
            ResolvedChain resolvedChain = this.resolver.resolve(chain, key, this.timeSource.getTimeMillis());
            Result result = resolvedChain.getResolvedResult(key);
            return result == null ? null : (V)result.getValue();
        }
        catch (Exception re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    @Override
    protected boolean silentRemove(K key) throws StoreAccessException {
        try {
            RemoveOperation operation = new RemoveOperation(key, this.timeSource.getTimeMillis());
            ByteBuffer payload = this.codec.encode(operation);
            long extractedKey = this.extractLongKey(key);
            Chain chain = this.storeProxy.getAndAppend(extractedKey, payload);
            ResolvedChain resolvedChain = this.resolver.resolve(chain, key, this.timeSource.getTimeMillis());
            return resolvedChain.getResolvedResult(key) != null;
        }
        catch (Exception re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    @Override
    protected V silentRemove(K key, V value) throws StoreAccessException {
        try {
            ConditionalRemoveOperation<K, V> operation = new ConditionalRemoveOperation<K, V>(key, value, this.timeSource.getTimeMillis());
            ByteBuffer payload = this.codec.encode(operation);
            long extractedKey = this.extractLongKey(key);
            Chain chain = this.storeProxy.getAndAppend(extractedKey, payload);
            ResolvedChain resolvedChain = this.resolver.resolve(chain, key, this.timeSource.getTimeMillis());
            Result result = resolvedChain.getResolvedResult(key);
            return result == null ? null : (V)result.getValue();
        }
        catch (Exception re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    @Override
    protected V silentReplace(K key, V value) throws StoreAccessException {
        try {
            ReplaceOperation<K, V> operation = new ReplaceOperation<K, V>(key, value, this.timeSource.getTimeMillis());
            ByteBuffer payload = this.codec.encode(operation);
            long extractedKey = this.extractLongKey(key);
            Chain chain = this.storeProxy.getAndAppend(extractedKey, payload);
            ResolvedChain resolvedChain = this.resolver.resolve(chain, key, this.timeSource.getTimeMillis());
            Result result = resolvedChain.getResolvedResult(key);
            return result == null ? null : (V)result.getValue();
        }
        catch (Exception re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    @Override
    protected V silentReplace(K key, V oldValue, V newValue) throws StoreAccessException {
        try {
            ConditionalReplaceOperation<K, V> operation = new ConditionalReplaceOperation<K, V>(key, oldValue, newValue, this.timeSource.getTimeMillis());
            ByteBuffer payload = this.codec.encode(operation);
            long extractedKey = this.extractLongKey(key);
            Chain chain = this.storeProxy.getAndAppend(extractedKey, payload);
            ResolvedChain resolvedChain = this.resolver.resolve(chain, key, this.timeSource.getTimeMillis());
            Result result = resolvedChain.getResolvedResult(key);
            return result == null ? null : (V)result.getValue();
        }
        catch (Exception re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    private ServerStoreProxy.ServerCallback getWriteBehindServerCallback(ServerStoreProxy.ServerCallback delegate) {
        return new WriteBehindServerCallback(delegate);
    }

    @ServiceDependencies(value={TimeSourceService.class, ClusteringService.class})
    public static class Provider
    extends ClusteredLoaderWriterStore.Provider {
        @Override
        protected <K, V> ClusteredStore<K, V> createStore(Store.Configuration<K, V> storeConfig, OperationsCodec<K, V> codec, ChainResolver<K, V> resolver, TimeSource timeSource, boolean useLoaderInAtomics, Object[] serviceConfigs) {
            WriteBehindConfiguration writeBehindConfiguration = (WriteBehindConfiguration)ServiceUtils.findSingletonAmongst(WriteBehindConfiguration.class, (Object[])serviceConfigs);
            if (writeBehindConfiguration != null) {
                ExecutorService executorService = this.executionService.getOrderedExecutor(writeBehindConfiguration.getThreadPoolAlias(), new LinkedBlockingQueue());
                return new ClusteredWriteBehindStore(storeConfig, codec, resolver, timeSource, storeConfig.getCacheLoaderWriter(), executorService);
            }
            throw new AssertionError();
        }

        @Override
        protected ServerStoreProxy.ServerCallback getServerCallback(ClusteredStore<?, ?> clusteredStore) {
            if (clusteredStore instanceof ClusteredWriteBehindStore) {
                return ((ClusteredWriteBehindStore)clusteredStore).getWriteBehindServerCallback(super.getServerCallback(clusteredStore));
            }
            throw new AssertionError();
        }

        @Override
        public int rank(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?>> serviceConfigs) {
            int parentRank;
            block3: {
                block2: {
                    parentRank = super.rank(resourceTypes, serviceConfigs);
                    if (parentRank == 0) break block2;
                    if (!serviceConfigs.stream().noneMatch(WriteBehindConfiguration.class::isInstance)) break block3;
                }
                return 0;
            }
            return parentRank + 1;
        }

        @Override
        public int rankAuthority(ResourceType<?> authorityResource, Collection<ServiceConfiguration<?>> serviceConfigs) {
            int parentRank;
            block3: {
                block2: {
                    parentRank = super.rankAuthority(authorityResource, serviceConfigs);
                    if (parentRank == 0) break block2;
                    if (!serviceConfigs.stream().noneMatch(WriteBehindConfiguration.class::isInstance)) break block3;
                }
                return 0;
            }
            return parentRank + 1;
        }
    }

    public class WriteBehindServerCallback
    implements ServerStoreProxy.ServerCallback {
        private final ServerStoreProxy.ServerCallback delegate;

        WriteBehindServerCallback(ServerStoreProxy.ServerCallback delegate) {
            this.delegate = delegate;
        }

        @Override
        public void onInvalidateHash(long hash) {
            this.delegate.onInvalidateHash(hash);
        }

        @Override
        public void onInvalidateAll() {
            this.delegate.onInvalidateAll();
        }

        @Override
        public Chain compact(Chain chain) {
            return this.delegate.compact(chain);
        }

        @Override
        public Chain compact(Chain chain, long hash) {
            ClusteredWriteBehindStore.this.clusteredWriteBehind.flushWriteBehindQueue(chain, hash);
            return null;
        }
    }
}

