/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease;

import java.io.Closeable;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.exception.ConnectionClosedException;
import org.terracotta.lease.LeaseException;
import org.terracotta.lease.LeaseMaintainerImpl;
import org.terracotta.lease.TimeSource;
import org.terracotta.lease.TimeSourceProvider;

class LeaseMaintenanceThread
extends Thread
implements Closeable {
    private static Logger LOGGER = LoggerFactory.getLogger(LeaseMaintenanceThread.class);
    private final LeaseMaintainerImpl leaseMaintainer;
    private final TimeSource timeSource;
    private volatile boolean shutdown = false;

    LeaseMaintenanceThread(LeaseMaintainerImpl leaseMaintainer) {
        this.leaseMaintainer = leaseMaintainer;
        this.timeSource = TimeSourceProvider.getTimeSource();
        this.setName("LeaseMaintenanceThread");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            try {
                long waitLength = this.leaseMaintainer.refreshLease();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Lease refresh wait: " + waitLength);
                }
                if (waitLength <= 0L) continue;
                this.timeSource.sleep(waitLength);
            }
            catch (ConnectionClosedException e) {
                return;
            }
            catch (InterruptedException e) {
                if (!this.shutdown) continue;
                return;
            }
            catch (LeaseException e) {
                LOGGER.error("Error obtaining lease", (Throwable)e);
            }
            finally {
                if (!this.shutdown) continue;
                return;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.shutdown = true;
        this.interrupt();
    }
}

