/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.config;

import com.tc.config.schema.L2ConfigForL1;
import com.tc.net.core.ConnectionInfo;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionInfoConfig {
    static Logger LOGGER = LoggerFactory.getLogger(ConnectionInfoConfig.class);
    private final ConnectionInfo[] connectionInfos;

    public ConnectionInfoConfig(L2ConfigForL1.L2Data[] l2sData) {
        this.connectionInfos = this.createValueFrom(l2sData);
    }

    private ConnectionInfo[] createValueFrom(L2ConfigForL1.L2Data[] l2sData) {
        ConnectionInfo[] out;
        String serversProperty = System.getProperty("tc.server");
        if (serversProperty != null && (serversProperty = serversProperty.trim()) != null && serversProperty.length() > 0) {
            LOGGER.info("tc.server: " + serversProperty);
            String[] serverDescs = serversProperty.split(",");
            int count = serverDescs.length;
            out = new ConnectionInfo[count];
            for (int i = 0; i < count; ++i) {
                String host;
                String serverDesc = serverDescs[i];
                int tsaPort = 9410;
                if (serverDesc.startsWith("[")) {
                    if (!serverDesc.contains("]")) {
                        throw new IllegalArgumentException(String.format("A tc.server element contains an invalid host '%s'. IPv6 address literals must be enclosed in '[' and ']' according to RFC 2732", serverDesc));
                    }
                    int end = serverDesc.indexOf("]");
                    host = serverDesc.substring(1, end);
                    String remainder = serverDesc.substring(end + 1);
                    if (!remainder.isEmpty() && remainder.charAt(0) == ':') {
                        String portString = remainder.substring(1);
                        try {
                            tsaPort = Integer.parseInt(portString);
                        }
                        catch (NumberFormatException nfe) {
                            LOGGER.info("Cannot parse port for tc.server element '" + portString + "'; Using default of 9410.");
                        }
                    }
                } else {
                    String[] parts = serverDesc.split(":");
                    String string = host = parts.length > 0 ? parts[0] : "localhost";
                    if (parts.length == 2) {
                        try {
                            tsaPort = Integer.parseInt(parts[1]);
                        }
                        catch (NumberFormatException nfe) {
                            LOGGER.info("Cannot parse port for tc.server element '" + serverDescs[i] + "'; Using default of 9410.");
                        }
                    }
                }
                out[i] = new ConnectionInfo(host, tsaPort);
            }
        } else {
            out = new ConnectionInfo[l2sData.length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = new ConnectionInfo(l2sData[i].host(), l2sData[i].tsaPort());
            }
        }
        return out;
    }

    public ConnectionInfo[] getConnectionInfos() {
        return this.connectionInfos;
    }

    public String toString() {
        return "ConnectionInfoConfig [connectionInfos=" + Arrays.toString(this.connectionInfos) + "]";
    }
}

