/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.ehcache.clustered.client.internal.store.ReconnectInProgressException;
import org.ehcache.clustered.client.internal.store.ServerStoreProxy;
import org.ehcache.clustered.client.internal.store.ServerStoreProxyException;
import org.ehcache.clustered.client.internal.store.lock.LockManager;
import org.ehcache.clustered.client.internal.store.lock.LockingServerStoreProxy;
import org.ehcache.clustered.common.internal.store.Chain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.exception.ConnectionClosedException;
import org.terracotta.exception.ConnectionShutdownException;

public class ReconnectingServerStoreProxy
implements ServerStoreProxy,
LockManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReconnectingServerStoreProxy.class);
    private final AtomicReference<LockingServerStoreProxy> delegateRef;
    private final Runnable onReconnect;

    public ReconnectingServerStoreProxy(ServerStoreProxy serverStoreProxy, Runnable onReconnect) {
        this.delegateRef = serverStoreProxy instanceof LockingServerStoreProxy ? new AtomicReference<LockingServerStoreProxy>((LockingServerStoreProxy)serverStoreProxy) : new AtomicReference<LockingServerStoreProxy>(new LockingServerStoreProxy(serverStoreProxy, new UnSupportedLockManager()));
        this.onReconnect = onReconnect;
    }

    @Override
    public String getCacheId() {
        return this.proxy().getCacheId();
    }

    @Override
    public void close() {
        try {
            this.proxy().close();
        }
        catch (ConnectionClosedException | ConnectionShutdownException e) {
            LOGGER.debug("Store was already closed, since connection was closed");
        }
    }

    @Override
    public Chain get(long key) throws TimeoutException {
        return this.onStoreProxy(serverStoreProxy -> serverStoreProxy.get(key));
    }

    @Override
    public void append(long key, ByteBuffer payLoad) throws TimeoutException {
        this.onStoreProxy(serverStoreProxy -> {
            serverStoreProxy.append(key, payLoad);
            return null;
        });
    }

    @Override
    public Chain getAndAppend(long key, ByteBuffer payLoad) throws TimeoutException {
        return this.onStoreProxy(serverStoreProxy -> serverStoreProxy.getAndAppend(key, payLoad));
    }

    @Override
    public void replaceAtHead(long key, Chain expect, Chain update) {
        try {
            this.onStoreProxy(serverStoreProxy -> {
                serverStoreProxy.replaceAtHead(key, expect, update);
                return null;
            });
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clear() throws TimeoutException {
        this.onStoreProxy(serverStoreProxy -> {
            serverStoreProxy.clear();
            return null;
        });
    }

    private LockingServerStoreProxy proxy() {
        return this.delegateRef.get();
    }

    private <T> T onStoreProxy(TimeoutExceptionFunction<LockingServerStoreProxy, T> function) throws TimeoutException {
        LockingServerStoreProxy storeProxy = this.proxy();
        try {
            return function.apply(storeProxy);
        }
        catch (ServerStoreProxyException sspe) {
            if (sspe.getCause() instanceof ConnectionClosedException) {
                if (this.delegateRef.compareAndSet(storeProxy, new ReconnectInProgressProxy(storeProxy.getCacheId()))) {
                    this.onReconnect.run();
                }
                return this.onStoreProxy(function);
            }
            throw sspe;
        }
    }

    @Override
    public Chain lock(long hash) throws TimeoutException {
        return this.onStoreProxy(lockingServerStoreProxy -> lockingServerStoreProxy.lock(hash));
    }

    @Override
    public void unlock(long hash) throws TimeoutException {
        this.onStoreProxy(lockingServerStoreProxy -> {
            lockingServerStoreProxy.unlock(hash);
            return null;
        });
    }

    private static class UnSupportedLockManager
    implements LockManager {
        private UnSupportedLockManager() {
        }

        @Override
        public Chain lock(long hash) throws TimeoutException {
            throw new UnsupportedOperationException("Lock ops are not supported");
        }

        @Override
        public void unlock(long hash) throws TimeoutException {
            throw new UnsupportedOperationException("Lock ops are not supported");
        }
    }

    private static class ReconnectInProgressProxy
    extends LockingServerStoreProxy {
        private final String cacheId;

        ReconnectInProgressProxy(String cacheId) {
            super(null, null);
            this.cacheId = cacheId;
        }

        @Override
        public String getCacheId() {
            return this.cacheId;
        }

        @Override
        public void close() {
            throw new ReconnectInProgressException();
        }

        @Override
        public Chain get(long key) {
            throw new ReconnectInProgressException();
        }

        @Override
        public void append(long key, ByteBuffer payLoad) {
            throw new ReconnectInProgressException();
        }

        @Override
        public Chain getAndAppend(long key, ByteBuffer payLoad) {
            throw new ReconnectInProgressException();
        }

        @Override
        public void replaceAtHead(long key, Chain expect, Chain update) {
            throw new ReconnectInProgressException();
        }

        @Override
        public void clear() {
            throw new ReconnectInProgressException();
        }

        @Override
        public Chain lock(long hash) throws TimeoutException {
            throw new ReconnectInProgressException();
        }

        @Override
        public void unlock(long hash) throws TimeoutException {
            throw new ReconnectInProgressException();
        }
    }

    @FunctionalInterface
    private static interface TimeoutExceptionFunction<U, V> {
        public V apply(U var1) throws TimeoutException;
    }
}

