/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store;

import java.util.Collections;
import java.util.Map;
import org.ehcache.clustered.client.internal.store.operations.Result;
import org.ehcache.clustered.common.internal.store.Chain;

public interface ResolvedChain<K, V> {
    public Chain getCompactedChain();

    public Result<K, V> getResolvedResult(K var1);

    public boolean isCompacted();

    public int getCompactionCount();

    public long getExpirationTime();

    public static class Impl<K, V>
    implements ResolvedChain<K, V> {
        private final Chain compactedChain;
        private final Map<K, Result<K, V>> resolvedOperations;
        private final int compactionCount;
        private final long expirationTime;

        public Impl(Chain compactedChain, Map<K, Result<K, V>> resolvedOperations, int compactionCount, long expirationTime) {
            this.compactedChain = compactedChain;
            this.resolvedOperations = resolvedOperations;
            this.compactionCount = compactionCount;
            this.expirationTime = expirationTime;
        }

        public Impl(Chain compactedChain, K key, Result<K, V> result, int compactedSize, long expirationTime) {
            this(compactedChain, Collections.singletonMap(key, result), compactedSize, expirationTime);
        }

        @Override
        public Chain getCompactedChain() {
            return this.compactedChain;
        }

        @Override
        public Result<K, V> getResolvedResult(K key) {
            return this.resolvedOperations.get(key);
        }

        @Override
        public boolean isCompacted() {
            return this.compactionCount > 0;
        }

        @Override
        public int getCompactionCount() {
            return this.compactionCount;
        }

        @Override
        public long getExpirationTime() {
            return this.expirationTime;
        }
    }
}

