/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.config.xml;

import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ehcache.clustered.client.config.ClusteredStoreConfiguration;
import org.ehcache.clustered.client.internal.config.xml.ClusteredCacheConstants;
import org.ehcache.clustered.client.internal.store.ClusteredStore;
import org.ehcache.clustered.common.Consistency;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.xml.CacheServiceConfigurationParser;
import org.ehcache.xml.DomUtil;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ClusteringCacheServiceConfigurationParser
implements CacheServiceConfigurationParser<ClusteredStore.Provider> {
    public static final String CLUSTERED_STORE_ELEMENT_NAME = "clustered-store";
    public static final String CONSISTENCY_ATTRIBUTE_NAME = "consistency";
    public static final String TC_CLUSTERED_NAMESPACE_PREFIX = "tc";
    public static final String COLON = ":";

    public Source getXmlSchema() throws IOException {
        return new StreamSource(ClusteredCacheConstants.XML_SCHEMA.openStream());
    }

    public URI getNamespace() {
        return ClusteredCacheConstants.NAMESPACE;
    }

    public ServiceConfiguration<ClusteredStore.Provider> parseServiceConfiguration(Element fragment) {
        if (CLUSTERED_STORE_ELEMENT_NAME.equals(fragment.getLocalName())) {
            if (fragment.hasAttribute(CONSISTENCY_ATTRIBUTE_NAME)) {
                return new ClusteredStoreConfiguration(Consistency.valueOf(fragment.getAttribute(CONSISTENCY_ATTRIBUTE_NAME).toUpperCase()));
            }
            return new ClusteredStoreConfiguration();
        }
        throw new XmlConfigurationException(String.format("XML configuration element <%s> in <%s> is not supported", fragment.getTagName(), fragment.getParentNode() == null ? "null" : fragment.getParentNode().getLocalName()));
    }

    public Class<ClusteredStore.Provider> getServiceType() {
        return ClusteredStore.Provider.class;
    }

    public Element unparseServiceConfiguration(ServiceConfiguration<ClusteredStore.Provider> serviceConfiguration) {
        try {
            this.validateParametersForTranslationToServiceConfig(serviceConfiguration);
            ClusteredStoreConfiguration clusteredStoreConfiguration = (ClusteredStoreConfiguration)serviceConfiguration;
            Consistency consistency = clusteredStoreConfiguration.getConsistency();
            Document doc = this.createDocumentRoot();
            Element defaultResourceElement = doc.createElement("tc:clustered-store");
            defaultResourceElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:tc", this.getNamespace().toString());
            defaultResourceElement.setAttribute(CONSISTENCY_ATTRIBUTE_NAME, consistency.name().toLowerCase());
            return defaultResourceElement;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new XmlConfigurationException((Throwable)e);
        }
    }

    private void validateParametersForTranslationToServiceConfig(ServiceConfiguration<ClusteredStore.Provider> clusterStoreConfiguration) {
        Objects.requireNonNull(clusterStoreConfiguration, "ServiceConfiguration must not be NULL");
        if (!(clusterStoreConfiguration instanceof ClusteredStoreConfiguration)) {
            throw new IllegalArgumentException("Parameter serviceCreationConfiguration must be of type ClusteredStoreConfiguration.Provided type of parameter is : " + clusterStoreConfiguration.getClass());
        }
    }

    private Document createDocumentRoot() throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder domBuilder = DomUtil.createAndGetDocumentBuilder();
        Document doc = domBuilder.newDocument();
        return doc;
    }
}

