/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.statistics.derived.histogram;

import java.util.Arrays;

public class ExponentialHistogram {
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private final double epsilon;
    private final int mergeThreshold;
    private final long window;
    private long[] boxes;
    private int[] insert;
    private long total;
    private long last;

    public ExponentialHistogram(double epsilon, long window) {
        this(epsilon, (int)(Math.ceil(Math.ceil(1.0 / epsilon) / 2.0) + 1.0), window, 0);
    }

    private ExponentialHistogram(double epsilon, int mergeThreshold, long window, int initialSize) {
        this.epsilon = epsilon;
        this.mergeThreshold = mergeThreshold;
        this.window = window;
        this.initializeArrays(initialSize);
    }

    public void merge(ExponentialHistogram b) {
        if (b.mergeThreshold != this.mergeThreshold) {
            throw new IllegalArgumentException();
        }
        this.merge(b.boxes, b.total);
    }

    private void merge(long[] bBoxes, long bTotal) {
        long[] aBoxes = this.boxes;
        long aTotal = this.total;
        int[] canonical = ExponentialHistogram.tailedLCanonical(this.mergeThreshold - 1, aTotal + bTotal);
        this.initializeArrays(canonical.length - 1);
        this.total = aTotal + bTotal;
        this.last = this.total == 0L ? 0L : 1L << canonical.length - 1;
        long[] overflow = EMPTY_LONG_ARRAY;
        for (int logSize = 0; logSize < canonical.length; ++logSize) {
            int boxCount = canonical[logSize];
            int min = this.min_l(logSize);
            int max = this.max_l(logSize);
            long[] merged = ExponentialHistogram.merge(aBoxes, bBoxes, min, max, overflow);
            int limit = ExponentialHistogram.reverseSort(merged);
            System.arraycopy(merged, 0, this.boxes, min, boxCount);
            int overflowSize = limit - boxCount;
            overflow = new long[overflowSize >> 1];
            for (int j = 0; j < overflow.length; ++j) {
                overflow[j] = merged[boxCount + 2 * j];
            }
        }
    }

    public void insert(long time, long count) throws IllegalArgumentException {
        if (count < 0L) {
            throw new IllegalArgumentException("negative count");
        }
        if (count == 0L) {
            return;
        }
        if (time == Long.MIN_VALUE) {
            ++time;
        }
        this.merge(this.makeBoxes(time, count), count);
    }

    private long[] makeBoxes(long time, long count) {
        int[] canonical = ExponentialHistogram.tailedLCanonical(this.mergeThreshold - 1, count);
        long[] boxes = new long[this.min_l(canonical.length)];
        Arrays.fill(boxes, Long.MIN_VALUE);
        for (int i = 0; i < canonical.length; ++i) {
            int min = this.min_l(i);
            Arrays.fill(boxes, min, min + canonical[i], time);
        }
        return boxes;
    }

    private static int[] tailedLCanonical(int l, long count) {
        if (count <= (long)l) {
            return new int[]{(int)count};
        }
        int[] form = ExponentialHistogram.lCanonical(l, count - (long)l);
        form[0] = form[0] + l;
        return form;
    }

    private static int[] lCanonical(int l, long count) {
        long num = count + (long)l;
        long denom = l + 1;
        int j = Long.numberOfTrailingZeros(Long.highestOneBit(num / denom));
        long offset = num - (denom << j);
        long prefixRep = offset & (1L << j) - 1L;
        int[] canonical = new int[j + 1];
        for (int i = 0; i < j; ++i) {
            canonical[i] = l + (int)(prefixRep >>> i & 1L);
        }
        canonical[j] = (int)((offset >>> j) + 1L);
        return canonical;
    }

    private static long[] merge(long[] a, long[] b, int min, int max, long[] c) {
        int width = max - min;
        if (max <= a.length) {
            if (max <= b.length) {
                long[] merged = Arrays.copyOf(c, c.length + 2 * width);
                System.arraycopy(a, min, merged, c.length, width);
                System.arraycopy(b, min, merged, c.length + width, width);
                return merged;
            }
            long[] merged = Arrays.copyOf(c, c.length + width);
            System.arraycopy(a, min, merged, c.length, width);
            return merged;
        }
        if (max <= b.length) {
            long[] merged = Arrays.copyOf(c, c.length + width);
            System.arraycopy(b, min, merged, c.length, width);
            return merged;
        }
        return c;
    }

    public void insert(long time) {
        if (time == Long.MIN_VALUE) {
            // empty if block
        }
        ++this.total;
        int logSize = 0;
        while (true) {
            this.ensureCapacity(logSize);
            int insertIndex = this.insert[logSize];
            long previous = this.boxes[insertIndex];
            this.boxes[insertIndex--] = ++time;
            if (insertIndex < this.min_l(logSize)) {
                insertIndex = this.max_l(logSize) - 1;
            }
            this.insert[logSize] = insertIndex;
            if (previous == Long.MIN_VALUE) {
                long finalSize = 1L << logSize;
                if (finalSize > this.last) {
                    this.last = finalSize;
                }
                return;
            }
            if (time - previous < this.window) {
                time = this.boxes[insertIndex];
                if (time == Long.MIN_VALUE) {
                    this.total -= 1L << logSize;
                    return;
                }
            } else {
                this.total -= 1L << logSize;
                return;
            }
            this.boxes[insertIndex] = Long.MIN_VALUE;
            ++logSize;
        }
    }

    public long expire(long time) {
        for (int logSize = 63 - Long.numberOfLeadingZeros(this.last); logSize >= 0; --logSize) {
            boolean live = false;
            for (int i = this.min_l(logSize); i < this.max_l(logSize); ++i) {
                long end = this.boxes[i];
                if (end == Long.MIN_VALUE) continue;
                if (time - end >= this.window) {
                    this.total -= 1L << logSize;
                    this.boxes[i] = Long.MIN_VALUE;
                    continue;
                }
                live = true;
            }
            if (!live) continue;
            this.last = 1L << logSize;
            return this.count();
        }
        this.last = 0L;
        return 0L;
    }

    private int min_l(int logSize) {
        if (logSize == 0) {
            return 0;
        }
        return (logSize + 1) * this.mergeThreshold - 1;
    }

    private int max_l(int logSize) {
        return this.min_l(logSize + 1);
    }

    public long count() {
        return this.total - (this.last >>> 1);
    }

    public ExponentialHistogram split(double fraction) {
        long[] originalBoxes = this.boxes;
        ExponentialHistogram that = new ExponentialHistogram(this.epsilon, this.window);
        that.total = Math.round((double)this.total * fraction);
        this.total -= that.total;
        int[] thisCanonical = ExponentialHistogram.tailedLCanonical(this.mergeThreshold - 1, this.total);
        int[] thatCanonical = ExponentialHistogram.tailedLCanonical(this.mergeThreshold - 1, that.total);
        this.last = this.total == 0L ? 0L : 1L << thisCanonical.length - 1;
        that.last = that.total == 0L ? 0L : 1L << thatCanonical.length - 1;
        this.initializeArrays(thisCanonical.length - 1);
        that.initializeArrays(thatCanonical.length - 1);
        for (int logSize = 0; logSize < Integer.max(thisCanonical.length, thatCanonical.length); ++logSize) {
            int thatBoxCount;
            int thisBoxCount = logSize < thisCanonical.length ? thisCanonical[logSize] : 0;
            int n = thatBoxCount = logSize < thatCanonical.length ? thatCanonical[logSize] : 0;
            if (fraction < 0.5) {
                this.transfer(originalBoxes, that.boxes, logSize, thatBoxCount);
                this.transfer(originalBoxes, this.boxes, logSize, thisBoxCount);
                continue;
            }
            this.transfer(originalBoxes, this.boxes, logSize, thisBoxCount);
            this.transfer(originalBoxes, that.boxes, logSize, thatBoxCount);
        }
        return that;
    }

    private void transfer(long[] originalBoxes, long[] targetBoxes, int logSize, int count) {
        if (count > 0) {
            int min = this.min_l(logSize);
            int max = this.max_l(logSize);
            int limit = min + count;
            int available = ExponentialHistogram.reverseSort(originalBoxes, min, max) - min;
            int pulldown = count - available;
            if (pulldown > 0) {
                long[] pulled = this.doubleUp(this.pull(originalBoxes, logSize + 1, pulldown + 1 >> 1));
                System.arraycopy(originalBoxes, min, targetBoxes, min, available);
                Arrays.fill(originalBoxes, min, min + available, Long.MIN_VALUE);
                System.arraycopy(pulled, 0, targetBoxes, min + available, pulldown);
                System.arraycopy(pulled, pulldown, originalBoxes, min, pulled.length - pulldown);
            } else {
                System.arraycopy(originalBoxes, min, targetBoxes, min, count);
                Arrays.fill(originalBoxes, min, limit, Long.MIN_VALUE);
            }
        }
    }

    private long[] pull(long[] originalBoxes, int logSize, int count) {
        int min = this.min_l(logSize);
        int max = this.max_l(logSize);
        int limit = min + count;
        int available = ExponentialHistogram.reverseSort(originalBoxes, min, max) - min;
        int pulldown = count - available;
        if (pulldown > 0) {
            long[] pulled = this.doubleUp(this.pull(originalBoxes, logSize + 1, pulldown + 1 >> 1));
            long[] boxes = Arrays.copyOfRange(originalBoxes, min, limit);
            Arrays.fill(originalBoxes, min, min + available, Long.MIN_VALUE);
            System.arraycopy(pulled, 0, boxes, available, pulldown);
            System.arraycopy(pulled, pulldown, originalBoxes, min, pulled.length - pulldown);
            return boxes;
        }
        long[] boxes = Arrays.copyOfRange(originalBoxes, min, limit);
        Arrays.fill(originalBoxes, min, limit, Long.MIN_VALUE);
        return boxes;
    }

    private long[] doubleUp(long[] a) {
        long[] da = new long[a.length << 1];
        for (int i = 0; i < a.length; ++i) {
            long l = a[i];
            da[i << 1] = l;
            da[(i << 1) + 1] = l;
        }
        return da;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("count = ").append(this.count()).append(" : ");
        for (int logSize = 0; logSize < this.insert.length; ++logSize) {
            long time;
            int i;
            for (i = this.insert[logSize] + 1; i < this.max_l(logSize); ++i) {
                time = this.boxes[i];
                if (time == Long.MIN_VALUE) continue;
                sb.append("[").append(1L << logSize).append("@").append(time).append("], ");
            }
            for (i = this.min_l(logSize); i < this.insert[logSize] + 1; ++i) {
                time = this.boxes[i];
                if (time == Long.MIN_VALUE) continue;
                sb.append("[").append(1L << logSize).append("@").append(time).append("], ");
            }
        }
        sb.delete(sb.length() - 2, sb.length());
        return sb.toString();
    }

    private static int reverseSort(long[] a) {
        return ExponentialHistogram.reverseSort(a, 0, a.length);
    }

    private static int reverseSort(long[] a, int fromIndex, int toIndex) {
        int i;
        if (fromIndex < 0 || toIndex > a.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int firstEmpty = toIndex;
        int j = i = fromIndex;
        while (i < toIndex - 1) {
            if (a[i] == Long.MIN_VALUE && firstEmpty == toIndex) {
                firstEmpty = i;
            }
            long ai = a[i + 1];
            while (ai > a[j]) {
                if (j == firstEmpty) {
                    ++firstEmpty;
                }
                a[j + 1] = a[j];
                if (j-- != fromIndex) continue;
            }
            a[j + 1] = ai;
            j = ++i;
        }
        if (a[toIndex - 1] == Long.MIN_VALUE && firstEmpty == toIndex) {
            firstEmpty = toIndex - 1;
        }
        return firstEmpty;
    }

    private void ensureCapacity(int logSize) {
        int max = this.max_l(logSize);
        if (max > this.boxes.length) {
            long[] newBoxes = Arrays.copyOf(this.boxes, max);
            int[] newInsert = Arrays.copyOf(this.insert, logSize + 1);
            Arrays.fill(newBoxes, this.boxes.length, newBoxes.length, Long.MIN_VALUE);
            this.boxes = newBoxes;
            this.insert = newInsert;
            this.insert[logSize] = max - 1;
        }
    }

    private void initializeArrays(int logMax) {
        this.boxes = new long[this.max_l(logMax)];
        Arrays.fill(this.boxes, Long.MIN_VALUE);
        this.insert = new int[logMax + 1];
        for (int i = 0; i < logMax + 1; ++i) {
            this.insert[i] = this.max_l(i) - 1;
        }
    }

    public double epsilon() {
        return this.epsilon;
    }
}

