/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class CustomLoaderBasedObjectInputStream
extends ObjectInputStream {
    private final ClassLoader loader;

    public CustomLoaderBasedObjectInputStream(InputStream in, ClassLoader loader) throws IOException {
        super(in);
        this.loader = loader;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            ClassLoader cl;
            ClassLoader classLoader = cl = this.loader == null ? Thread.currentThread().getContextClassLoader() : this.loader;
            if (cl == null) {
                return super.resolveClass(desc);
            }
            try {
                return Class.forName(desc.getName(), false, cl);
            }
            catch (ClassNotFoundException e) {
                return super.resolveClass(desc);
            }
        }
        catch (SecurityException ex) {
            return super.resolveClass(desc);
        }
    }
}

