/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.runnel.metadata;

import org.terracotta.runnel.decoding.fields.ArrayField;
import org.terracotta.runnel.decoding.fields.Field;
import org.terracotta.runnel.metadata.Metadata;

public class FieldSearcher {
    private final Metadata metadata;
    private int lastIndex = -1;

    FieldSearcher(Metadata metadata) {
        this.metadata = metadata;
    }

    public <T extends Field, S extends Field> T findField(String name, Class<T> fieldClazz, Class<S> subFieldClazz) {
        ArrayField arrayField;
        Field nextSubField;
        Field field = this.metadata.getFieldByName(name);
        if (field == null) {
            throw new IllegalArgumentException("No such field : " + name);
        }
        if (field.index() <= this.lastIndex) {
            throw new IllegalArgumentException("No such field left : '" + name + "'");
        }
        this.lastIndex = field.index();
        if (field.getClass() != fieldClazz) {
            throw new IllegalArgumentException("Invalid type for field '" + name + "', expected : '" + fieldClazz.getSimpleName() + "' but was '" + field.getClass().getSimpleName() + "'");
        }
        if (subFieldClazz != null && !(nextSubField = (arrayField = (ArrayField)field).subField()).getClass().equals(subFieldClazz)) {
            throw new IllegalArgumentException("Invalid subtype for field '" + name + "', expected : '" + subFieldClazz.getSimpleName() + "' but was '" + nextSubField.getClass().getSimpleName() + "'");
        }
        return (T)field;
    }
}

