/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.net.ClientID;
import com.tc.net.core.TCConnection;
import com.tc.net.protocol.IllegalReconnectException;
import com.tc.net.protocol.NetworkStackHarness;
import com.tc.net.protocol.NetworkStackHarnessFactory;
import com.tc.net.protocol.ProductNotSupportedException;
import com.tc.net.protocol.ProtocolAdaptorFactory;
import com.tc.net.protocol.RejectReconnectionException;
import com.tc.net.protocol.ServerNetworkStackHarness;
import com.tc.net.protocol.TCProtocolAdaptor;
import com.tc.net.protocol.tcm.ServerMessageChannelFactory;
import com.tc.net.protocol.tcm.msgs.CommsMessageFactory;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.ConnectionIDFactory;
import com.tc.net.protocol.transport.ConnectionPolicy;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.MessageTransportFactory;
import com.tc.net.protocol.transport.MessageTransportListener;
import com.tc.net.protocol.transport.NetworkStackProvider;
import com.tc.net.protocol.transport.SynMessage;
import com.tc.net.protocol.transport.TransportHandshakeError;
import com.tc.net.protocol.transport.TransportHandshakeErrorContext;
import com.tc.net.protocol.transport.TransportHandshakeErrorHandler;
import com.tc.net.protocol.transport.TransportHandshakeMessage;
import com.tc.net.protocol.transport.TransportHandshakeMessageFactory;
import com.tc.net.protocol.transport.WireProtocolAdaptorFactory;
import com.tc.net.protocol.transport.WireProtocolMessage;
import com.tc.net.protocol.transport.WireProtocolMessageSink;
import com.tc.operatorevent.NodeNameProvider;
import com.tc.util.Assert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerStackProvider
implements NetworkStackProvider,
MessageTransportListener,
ProtocolAdaptorFactory {
    private static final Logger logger = LoggerFactory.getLogger(ServerStackProvider.class);
    private final Map<ClientID, ServerNetworkStackHarness> harnesses = new ConcurrentHashMap<ClientID, ServerNetworkStackHarness>();
    private final NetworkStackHarnessFactory harnessFactory;
    private final ServerMessageChannelFactory channelFactory;
    private final TransportHandshakeMessageFactory handshakeMessageFactory;
    private final ConnectionIDFactory connectionIdFactory;
    private final ConnectionPolicy connectionPolicy;
    private final WireProtocolAdaptorFactory wireProtocolAdaptorFactory;
    private final WireProtocolMessageSink wireProtoMsgsink;
    private final MessageTransportFactory messageTransportFactory;
    private final List<MessageTransportListener> transportListeners = new ArrayList<MessageTransportListener>();
    private final ReentrantLock licenseLock;
    private final String commsMgrName;
    private final NodeNameProvider activeProvider;
    private final Predicate<MessageTransport> validateTransport;

    public ServerStackProvider(Set<ClientID> initialConnectionIDs, NetworkStackHarnessFactory harnessFactory, ServerMessageChannelFactory channelFactory, MessageTransportFactory messageTransportFactory, TransportHandshakeMessageFactory handshakeMessageFactory, ConnectionIDFactory connectionIdFactory, ConnectionPolicy connectionPolicy, WireProtocolAdaptorFactory wireProtocolAdaptorFactory, ReentrantLock licenseLock) {
        this(initialConnectionIDs, null, t -> true, harnessFactory, channelFactory, messageTransportFactory, handshakeMessageFactory, connectionIdFactory, connectionPolicy, wireProtocolAdaptorFactory, null, licenseLock, "L2_L1");
    }

    public ServerStackProvider(Set<ClientID> initialConnectionIDs, NodeNameProvider activeProvider, Predicate<MessageTransport> validate, NetworkStackHarnessFactory harnessFactory, ServerMessageChannelFactory channelFactory, MessageTransportFactory messageTransportFactory, TransportHandshakeMessageFactory handshakeMessageFactory, ConnectionIDFactory connectionIdFactory, ConnectionPolicy connectionPolicy, WireProtocolAdaptorFactory wireProtocolAdaptorFactory, WireProtocolMessageSink wireProtoMsgSink, ReentrantLock licenseLock, String commsMgrName) {
        this.messageTransportFactory = messageTransportFactory;
        this.connectionPolicy = connectionPolicy;
        this.wireProtocolAdaptorFactory = wireProtocolAdaptorFactory;
        this.wireProtoMsgsink = wireProtoMsgSink;
        Assert.assertNotNull(harnessFactory);
        this.harnessFactory = harnessFactory;
        this.channelFactory = channelFactory;
        this.handshakeMessageFactory = handshakeMessageFactory;
        this.connectionIdFactory = connectionIdFactory;
        this.transportListeners.add(this);
        Assert.assertNotNull(licenseLock);
        this.licenseLock = licenseLock;
        this.commsMgrName = commsMgrName;
        for (ClientID clientID : initialConnectionIDs) {
            logger.info("Preparing comms stack for previously connected client: " + clientID);
            this.newStackHarness(clientID, messageTransportFactory.createNewTransport(this.createHandshakeErrorHandler(), handshakeMessageFactory, this.transportListeners));
        }
        this.activeProvider = activeProvider;
        this.validateTransport = validate;
    }

    @Override
    public MessageTransport attachNewConnection(ConnectionID connectionId, TCConnection connection) throws RejectReconnectionException, ProductNotSupportedException {
        MessageTransport rv;
        Assert.assertNotNull(connection);
        if (this.activeProvider != null || connectionId.isNewConnection()) {
            if ((connectionId = this.connectionIdFactory.populateConnectionID(connectionId)) == ConnectionID.NULL_ID) {
                throw new ProductNotSupportedException((Object)((Object)connectionId.getProductId()) + " not supported");
            }
            rv = this.messageTransportFactory.createNewTransport(connection, this.createHandshakeErrorHandler(), this.handshakeMessageFactory, this.transportListeners);
            rv.initConnectionID(connectionId);
            this.newStackHarness(connectionId.getClientID(), rv).finalizeStack();
        } else {
            ServerNetworkStackHarness harness = this.harnesses.get(connectionId.getClientID());
            if (harness == null) {
                throw new RejectReconnectionException("Stack for " + connectionId + " not found.", connection.getRemoteAddress());
            }
            if ((connectionId = this.connectionIdFactory.populateConnectionID(connectionId)) == ConnectionID.NULL_ID) {
                throw new RejectReconnectionException("Stack for " + connectionId + " not found.", connection.getRemoteAddress());
            }
            try {
                boolean finalize = harness.getTransport().getConnectionId().isNull();
                harness.getTransport().initConnectionID(connectionId);
                if (finalize) {
                    harness.finalizeStack();
                }
                rv = harness.attachNewConnection(connection);
            }
            catch (IllegalReconnectException e) {
                logger.warn("Client attempting an illegal reconnect for id " + connectionId + ", " + connection);
                throw new RejectReconnectionException("Illegal reconnect attempt from " + connectionId + ".", connection.getRemoteAddress());
            }
        }
        return rv;
    }

    private NetworkStackHarness newStackHarness(ClientID id, MessageTransport transport) {
        ServerNetworkStackHarness harness = this.harnessFactory.createServerHarness(this.channelFactory, transport, new MessageTransportListener[]{this});
        ServerNetworkStackHarness previous = this.harnesses.put(id, harness);
        if (previous != null) {
            throw new AssertionError((Object)("previous is " + previous + "connectionID:" + id + "new is" + harness));
        }
        return harness;
    }

    private TransportHandshakeErrorHandler createHandshakeErrorHandler() {
        return new TransportHandshakeErrorHandler(){

            @Override
            public void handleHandshakeError(TransportHandshakeErrorContext thec) {
                logger.info(thec.getMessage());
            }
        };
    }

    NetworkStackHarness removeNetworkStack(ConnectionID connectionId) {
        return this.harnesses.remove(connectionId.getClientID());
    }

    @Override
    public void notifyTransportConnected(MessageTransport transport) {
    }

    @Override
    public void notifyTransportDisconnected(MessageTransport transport, boolean forcedDisconnect) {
        this.connectionPolicy.clientDisconnected(transport.getConnectionId());
    }

    private void close(ConnectionID connectionId) {
        NetworkStackHarness harness = this.removeNetworkStack(connectionId);
        if (harness == null) {
            throw new AssertionError((Object)("Receive a transport closed event for a transport that isn't in the map :" + connectionId));
        }
    }

    @Override
    public void notifyTransportConnectAttempt(MessageTransport transport) {
    }

    @Override
    public void notifyTransportClosed(MessageTransport transport) {
        this.close(transport.getConnectionId());
        if (!transport.getConnectionId().isJvmIDNull()) {
            this.connectionPolicy.clientDisconnected(transport.getConnectionId());
        }
    }

    @Override
    public void notifyTransportReconnectionRejected(MessageTransport transport) {
    }

    @Override
    public TCProtocolAdaptor getInstance() {
        if (this.wireProtoMsgsink != null) {
            return this.wireProtocolAdaptorFactory.newWireProtocolAdaptor(this.wireProtoMsgsink);
        }
        MessageSink sink = new MessageSink(this.createHandshakeErrorHandler(), this.commsMgrName);
        return this.wireProtocolAdaptorFactory.newWireProtocolAdaptor(sink);
    }

    class MessageSink
    implements WireProtocolMessageSink {
        private final TransportHandshakeErrorHandler handshakeErrorHandler;
        private final String commsManagerName;
        private volatile boolean isSynReceived = false;
        private volatile boolean isHandshakeError = false;
        private volatile MessageTransport transport;

        private MessageSink(TransportHandshakeErrorHandler handshakeErrorHandler, String commsMgrName) {
            this.handshakeErrorHandler = handshakeErrorHandler;
            this.commsManagerName = commsMgrName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putMessage(WireProtocolMessage message) {
            if (!this.isSynReceived) {
                MessageSink messageSink = this;
                synchronized (messageSink) {
                    if (!this.isSynReceived) {
                        this.isSynReceived = this.verifyAndHandleSyn(message);
                        message.recycle();
                        return;
                    }
                }
            }
            if (this.isHandshakeError) {
                throw new AssertionError((Object)"clients should not send messages after handshake error");
            }
            this.transport.receiveTransportMessage(message);
        }

        private boolean verifyAndHandleSyn(WireProtocolMessage message) {
            boolean isSynced = false;
            if (!this.verifySyn(message)) {
                this.handleHandshakeError(new TransportHandshakeErrorContext("Expected a SYN message but received: " + message, TransportHandshakeError.ERROR_HANDSHAKE));
            } else {
                try {
                    this.handleSyn((SynMessage)message);
                    isSynced = true;
                }
                catch (RejectReconnectionException e) {
                    String errorMessage = CommsMessageFactory.createReconnectRejectMessage(this.commsManagerName, new Object[]{e.getMessage()});
                    this.transport = ServerStackProvider.this.messageTransportFactory.createNewTransport(((SynMessage)message).getSource(), ServerStackProvider.this.createHandshakeErrorHandler(), ServerStackProvider.this.handshakeMessageFactory, ServerStackProvider.this.transportListeners);
                    this.transport.initConnectionID(((SynMessage)message).getConnectionId());
                    TransportHandshakeErrorContext cxt = new TransportHandshakeErrorContext(errorMessage, TransportHandshakeError.ERROR_RECONNECTION_REJECTED);
                    this.sendSynAck(((SynMessage)message).getConnectionId(), cxt, ((SynMessage)message).getSource(), false);
                    this.handleHandshakeError(new TransportHandshakeErrorContext(errorMessage, e));
                }
                catch (ProductNotSupportedException product) {
                    this.transport = ServerStackProvider.this.messageTransportFactory.createNewTransport(((SynMessage)message).getSource(), ServerStackProvider.this.createHandshakeErrorHandler(), ServerStackProvider.this.handshakeMessageFactory, ServerStackProvider.this.transportListeners);
                    this.transport.initConnectionID(((SynMessage)message).getConnectionId());
                    TransportHandshakeErrorContext cxt = new TransportHandshakeErrorContext(product.getMessage(), TransportHandshakeError.ERROR_PRODUCT_NOT_SUPPORTED);
                    this.sendSynAck(((SynMessage)message).getConnectionId(), cxt, ((SynMessage)message).getSource(), false);
                    this.handleHandshakeError(cxt);
                }
            }
            return isSynced;
        }

        private void handleHandshakeError(TransportHandshakeErrorContext ctxt) {
            this.isHandshakeError = true;
            this.handshakeErrorHandler.handleHandshakeError(ctxt);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleSyn(SynMessage syn) throws RejectReconnectionException, ProductNotSupportedException {
            ConnectionID connectionId = syn.getConnectionId();
            boolean isMaxConnectionReached = false;
            if (connectionId == null) {
                this.transport = ServerStackProvider.this.messageTransportFactory.createNewTransport(syn.getSource(), ServerStackProvider.this.createHandshakeErrorHandler(), ServerStackProvider.this.handshakeMessageFactory, ServerStackProvider.this.transportListeners);
                this.sendSynAck(new TransportHandshakeErrorContext("Invalid connection id: " + connectionId, TransportHandshakeError.ERROR_INVALID_CONNECTION_ID), syn.getSource(), isMaxConnectionReached);
                this.isHandshakeError = true;
                return;
            }
            ServerStackProvider.this.licenseLock.lock();
            try {
                if (connectionId.isNewConnection() && !ServerStackProvider.this.connectionPolicy.isConnectAllowed(connectionId)) {
                    isMaxConnectionReached = true;
                    this.transport = ServerStackProvider.this.messageTransportFactory.createNewTransport(syn.getSource(), ServerStackProvider.this.createHandshakeErrorHandler(), ServerStackProvider.this.handshakeMessageFactory, ServerStackProvider.this.transportListeners);
                    this.transport.initConnectionID(this.transport.getConnectionId());
                } else {
                    this.transport = ServerStackProvider.this.attachNewConnection(connectionId, syn.getSource());
                    isMaxConnectionReached = !ServerStackProvider.this.connectionPolicy.connectClient(this.transport.getConnectionId());
                }
            }
            finally {
                ServerStackProvider.this.licenseLock.unlock();
            }
            connectionId = this.transport.getConnectionId();
            this.transport.setRemoteCallbackPort(syn.getCallbackPort());
            short clientStackLayerFlags = syn.getStackLayerFlags();
            short serverStackLayerFlags = this.transport.getCommunicationStackFlags(this.transport);
            if (!isMaxConnectionReached && clientStackLayerFlags != serverStackLayerFlags) {
                String layersPresentInServer = "Layers Present in Server side communication stack: ";
                layersPresentInServer = layersPresentInServer + this.transport.getCommunicationStackNames(this.transport);
                this.sendSynAck(connectionId, new TransportHandshakeErrorContext(layersPresentInServer, TransportHandshakeError.ERROR_STACK_MISMATCH), syn.getSource(), isMaxConnectionReached);
                if ((serverStackLayerFlags & 2) != 0) {
                    logger.error("Once and Only Once Protocol Layer is present in server but not in client");
                } else {
                    logger.error("Once and Only Once Protocol Layer is present in client but not in server");
                }
                this.isHandshakeError = true;
                return;
            }
            if (!ServerStackProvider.this.validateTransport.test(this.transport)) {
                this.sendSynAck(connectionId, new TransportHandshakeErrorContext("connection not allowed", TransportHandshakeError.ERROR_NO_ACTIVE), syn.getSource(), isMaxConnectionReached);
                return;
            }
            this.sendSynAck(this.transport.getConnectionId(), syn.getSource(), isMaxConnectionReached);
        }

        private boolean verifySyn(WireProtocolMessage message) {
            return message instanceof TransportHandshakeMessage && ((TransportHandshakeMessage)message).isSyn();
        }

        private void sendSynAck(ConnectionID connectionId, TCConnection source, boolean isMaxConnectionReached) {
            source.addWeight(1);
            this.sendSynAck(connectionId, null, source, isMaxConnectionReached);
        }

        private void sendSynAck(TransportHandshakeErrorContext errorContext, TCConnection source, boolean isMaxConnectionsReached) {
            Assert.eval(errorContext != null);
            this.sendSynAck(null, errorContext, source, isMaxConnectionsReached);
        }

        private void sendSynAck(ConnectionID connectionId, TransportHandshakeErrorContext errorContext, TCConnection source, boolean isMaxConnectionsReached) {
            TransportHandshakeMessage synAck;
            boolean isError = errorContext != null;
            int maxConnections = ServerStackProvider.this.connectionPolicy.getMaxConnections();
            if (isError) {
                synAck = ServerStackProvider.this.handshakeMessageFactory.createSynAck(connectionId, errorContext.getErrorType(), errorContext.getMessage(), source, isMaxConnectionsReached, maxConnections);
            } else if (ServerStackProvider.this.activeProvider != null) {
                String active = ServerStackProvider.this.activeProvider.getNodeName();
                synAck = active != null ? ServerStackProvider.this.handshakeMessageFactory.createSynAck(connectionId, TransportHandshakeError.ERROR_REDIRECT_CONNECTION, active, source, isMaxConnectionsReached, maxConnections) : ServerStackProvider.this.handshakeMessageFactory.createSynAck(connectionId, TransportHandshakeError.ERROR_NO_ACTIVE, "no active", source, isMaxConnectionsReached, maxConnections);
            } else {
                int callbackPort = source.getLocalAddress().getPort();
                synAck = ServerStackProvider.this.handshakeMessageFactory.createSynAck(connectionId, source, isMaxConnectionsReached, maxConnections, callbackPort);
            }
            this.sendMessage(synAck);
        }

        private void sendMessage(WireProtocolMessage message) {
            try {
                this.transport.sendToConnection(message);
            }
            catch (IOException ioe) {
                logger.warn("trouble sending message", (Throwable)ioe);
            }
        }
    }
}

