/*
 * Decompiled with CFR 0.152.
 */
package com.tc.io;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.io.TCByteBufferOutput;
import com.tc.util.Assert;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.List;

public final class TCByteBufferOutputStream
extends OutputStream
implements TCByteBufferOutput {
    private static final int DEFAULT_MAX_BLOCK_SIZE = 524288;
    private static final int DEFAULT_INITIAL_BLOCK_SIZE = 1024;
    private final boolean direct;
    private final int maxBlockSize;
    private final DataOutputStream dos;
    private List<TCByteBuffer> buffers = new ArrayList<TCByteBuffer>(16);
    private final List<TCByteBuffer> localBuffers = new ArrayList<TCByteBuffer>(16);
    private TCByteBuffer current;
    private boolean closed;
    private int written;
    private int blockSize;

    public TCByteBufferOutputStream() {
        this(1024, 524288, false);
    }

    public TCByteBufferOutputStream(int blockSize, boolean direct) {
        this(blockSize, blockSize, false);
    }

    public TCByteBufferOutputStream(int initialBlockSize, int maxBlockSize, boolean direct) {
        if (maxBlockSize < 1) {
            throw new IllegalArgumentException("Max block size must be greater than or equal to 1");
        }
        if (initialBlockSize < 1) {
            throw new IllegalArgumentException("Initial block size must be greater than or equal to 1");
        }
        if (maxBlockSize < initialBlockSize) {
            throw new IllegalArgumentException("Initial block size less than max block size");
        }
        this.maxBlockSize = maxBlockSize;
        this.blockSize = initialBlockSize;
        this.direct = direct;
        this.closed = false;
        this.dos = new DataOutputStream(this);
        this.addBuffer();
    }

    public Mark mark() {
        this.checkClosed();
        return new Mark(this.buffers.size(), this.current.position(), this.getBytesWritten());
    }

    @Override
    public void write(int b) {
        this.checkClosed();
        ++this.written;
        if (!this.current.hasRemaining()) {
            this.addBuffer();
        }
        this.current.put((byte)b);
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void write(TCByteBuffer data) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.write(new TCByteBuffer[]{data});
    }

    @Override
    public void write(TCByteBuffer[] data) {
        boolean reuseCurrent;
        this.checkClosed();
        if (data == null) {
            throw new NullPointerException();
        }
        if (data.length == 0) {
            return;
        }
        boolean bl = reuseCurrent = this.current.position() == 0;
        if (!reuseCurrent) {
            this.buffers.add(this.current.limit(this.current.position()).position(0));
        }
        for (TCByteBuffer element : data) {
            int len = element.limit();
            if (len == 0) continue;
            this.written += len;
            this.buffers.add(element.duplicate().position(0));
        }
        if (!reuseCurrent) {
            this.current = this.buffers.remove(this.buffers.size() - 1);
            this.current.position(this.current.limit());
        }
    }

    public int getBytesWritten() {
        return this.written;
    }

    @Override
    public void write(byte[] b, int offset, int length) {
        this.checkClosed();
        if (b == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > b.length || length < 0 || offset + length > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        this.written += length;
        int index = offset;
        int numToWrite = length;
        while (numToWrite > 0) {
            if (!this.current.hasRemaining()) {
                this.addBuffer();
            }
            int numToPut = Math.min(this.current.remaining(), numToWrite);
            this.current.put(b, index, numToPut);
            numToWrite -= numToPut;
            index += numToPut;
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.finalizeBuffers();
            this.closed = true;
        }
    }

    @Override
    public TCByteBuffer[] toArray() {
        this.close();
        TCByteBuffer[] rv = new TCByteBuffer[this.buffers.size()];
        return this.buffers.toArray(rv);
    }

    public String toString() {
        return this.buffers == null ? "null" : this.buffers.toString();
    }

    private void addBuffer() {
        if (this.current != null) {
            this.current.flip();
            this.buffers.add(this.current);
            if (this.blockSize < this.maxBlockSize) {
                this.blockSize *= 2;
                if (this.blockSize > this.maxBlockSize) {
                    this.blockSize = this.maxBlockSize;
                }
            }
        }
        this.current = this.newBuffer(this.blockSize);
        this.blockSize = this.current.capacity();
    }

    private TCByteBuffer newBuffer(int size) {
        TCByteBuffer rv = TCByteBufferFactory.getInstance(this.direct, size);
        this.localBuffers.add(rv);
        return rv;
    }

    private void finalizeBuffers() {
        if (this.current.position() > 0) {
            this.current.flip();
            this.buffers.add(this.current);
        }
        this.current = null;
        ArrayList<TCByteBuffer> finalBufs = new ArrayList<TCByteBuffer>();
        int num = this.buffers.size();
        for (int index = 0; index < num; ++index) {
            int startIndex = index;
            int size = this.buffers.get(startIndex).limit();
            if (size < this.maxBlockSize) {
                int nextSize;
                while (index < num - 1 && size + (nextSize = this.buffers.get(index + 1).limit()) <= this.maxBlockSize) {
                    size += nextSize;
                    ++index;
                }
            }
            if (index > startIndex) {
                TCByteBuffer consolidated = this.newBuffer(size);
                int end = index;
                for (int i = startIndex; i <= end; ++i) {
                    consolidated.put(this.buffers.get(i));
                }
                Assert.assertEquals(size, consolidated.position());
                consolidated.flip();
                finalBufs.add(consolidated);
                continue;
            }
            finalBufs.add(this.buffers.get(index));
        }
        this.buffers = finalBufs;
    }

    @Override
    public void writeBoolean(boolean value) {
        try {
            this.dos.writeBoolean(value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeByte(int value) {
        try {
            this.dos.writeByte(value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeChar(int value) {
        try {
            this.dos.writeChar(value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeDouble(double value) {
        try {
            this.dos.writeDouble(value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeFloat(float value) {
        try {
            this.dos.writeFloat(value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeInt(int value) {
        try {
            this.dos.writeInt(value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeLong(long value) {
        try {
            this.dos.writeLong(value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeShort(int value) {
        try {
            this.dos.writeShort(value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeString(String string) {
        this.writeString(string, false);
    }

    private void writeString(String string, boolean forceRaw) {
        if (string == null) {
            this.writeBoolean(true);
            return;
        }
        this.writeBoolean(false);
        if (!forceRaw) {
            Mark mark = this.mark();
            this.write(1);
            try {
                this.dos.writeUTF(string);
                return;
            }
            catch (IOException e) {
                if (!(e instanceof UTFDataFormatException)) {
                    throw new AssertionError((Object)e);
                }
                mark.write(0);
            }
        } else {
            this.write(0);
        }
        this.writeStringAsRawChars(string);
    }

    private void writeStringAsRawChars(String string) {
        if (string == null) {
            throw new AssertionError();
        }
        this.writeInt(string.length());
        try {
            this.dos.writeChars(string);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("stream is closed");
        }
    }

    @Override
    public void recycle() {
        if (this.localBuffers.size() > 0) {
            for (TCByteBuffer buffer : this.localBuffers) {
                buffer.recycle();
            }
        }
    }

    @Override
    public void writeBytes(String s) {
        throw new UnsupportedOperationException("use writeString() instead");
    }

    @Override
    public void writeChars(String s) {
        this.writeString(s, true);
    }

    @Override
    public void writeUTF(String str) {
        this.writeString(str);
    }

    public class Mark {
        private final int bufferIndex;
        private final int bufferPosition;
        private final int absolutePosition;

        private Mark(int bufferIndex, int bufferPosition, int absolutePosition) {
            this.bufferIndex = bufferIndex;
            this.bufferPosition = bufferPosition;
            this.absolutePosition = absolutePosition;
        }

        public int getPosition() {
            return this.absolutePosition;
        }

        public void write(byte[] data) {
            TCByteBufferOutputStream.this.checkClosed();
            if (data == null) {
                throw new NullPointerException();
            }
            if (data.length == 0) {
                return;
            }
            if (TCByteBufferOutputStream.this.getBytesWritten() - this.absolutePosition < data.length) {
                throw new IllegalArgumentException("Cannot write past the existing tail of stream via the mark");
            }
            TCByteBuffer buf = this.getBuffer(this.bufferIndex);
            int bufIndex = this.bufferIndex;
            int bufPos = this.bufferPosition;
            int dataIndex = 0;
            int numToWrite = data.length;
            while (numToWrite > 0) {
                int howMany = Math.min(numToWrite, buf.limit() - bufPos);
                if (howMany > 0) {
                    buf.put(bufPos, data, dataIndex, howMany);
                    dataIndex += howMany;
                    if ((numToWrite -= howMany) == 0) {
                        return;
                    }
                }
                buf = this.getBuffer(++bufIndex);
                bufPos = 0;
            }
        }

        private TCByteBuffer getBuffer(int index) {
            int buffersSize = TCByteBufferOutputStream.this.buffers.size();
            if (index < buffersSize) {
                return (TCByteBuffer)TCByteBufferOutputStream.this.buffers.get(index);
            }
            if (index == buffersSize) {
                return TCByteBufferOutputStream.this.current;
            }
            throw Assert.failure("index=" + index + ", buffers.size()=" + TCByteBufferOutputStream.this.buffers.size());
        }

        public void write(int b) {
            this.write(new byte[]{(byte)b});
        }

        public void copyTo(TCByteBufferOutput dest, int length) {
            this.copyTo(dest, 0, length);
        }

        public void copyTo(TCByteBufferOutput dest, int offset, int length) {
            int num;
            byte[] array;
            if (length < 0) {
                throw new IllegalArgumentException("length: " + length);
            }
            if (this.absolutePosition + offset + length > TCByteBufferOutputStream.this.getBytesWritten()) {
                throw new IllegalArgumentException("not enough data for copy of " + length + " bytes starting at position " + (this.absolutePosition + offset) + " of stream of size " + TCByteBufferOutputStream.this.getBytesWritten());
            }
            int index = this.bufferIndex;
            int pos = this.bufferPosition;
            while (offset > 0) {
                array = this.getBuffer(index).array();
                if ((offset -= (num = Math.min(array.length - pos, offset))) == 0) {
                    if (index > this.bufferIndex) {
                        pos = num;
                        break;
                    }
                    pos += num;
                    break;
                }
                pos = 0;
                ++index;
            }
            while (length > 0) {
                array = this.getBuffer(index++).array();
                num = Math.min(array.length - pos, length);
                dest.write(array, pos, num);
                length -= num;
                pos = 0;
            }
        }
    }
}

