/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store.operations;

import java.nio.ByteBuffer;
import org.ehcache.clustered.client.internal.store.operations.ConditionalRemoveOperation;
import org.ehcache.clustered.client.internal.store.operations.ConditionalReplaceOperation;
import org.ehcache.clustered.client.internal.store.operations.Operation;
import org.ehcache.clustered.client.internal.store.operations.PutIfAbsentOperation;
import org.ehcache.clustered.client.internal.store.operations.PutOperation;
import org.ehcache.clustered.client.internal.store.operations.RemoveOperation;
import org.ehcache.clustered.client.internal.store.operations.ReplaceOperation;
import org.ehcache.spi.serialization.Serializer;

public enum OperationCode {
    PUT(1){

        @Override
        public <K, V> Operation<K, V> decode(ByteBuffer buffer, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
            return new PutOperation<K, V>(buffer, keySerializer, valueSerializer);
        }
    }
    ,
    REMOVE(2){

        @Override
        public <K, V> Operation<K, V> decode(ByteBuffer buffer, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
            return new RemoveOperation(buffer, keySerializer);
        }
    }
    ,
    PUT_IF_ABSENT(3){

        @Override
        public <K, V> Operation<K, V> decode(ByteBuffer buffer, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
            return new PutIfAbsentOperation<K, V>(buffer, keySerializer, valueSerializer);
        }
    }
    ,
    REMOVE_CONDITIONAL(4){

        @Override
        public <K, V> Operation<K, V> decode(ByteBuffer buffer, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
            return new ConditionalRemoveOperation<K, V>(buffer, keySerializer, valueSerializer);
        }
    }
    ,
    REPLACE(5){

        @Override
        public <K, V> Operation<K, V> decode(ByteBuffer buffer, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
            return new ReplaceOperation<K, V>(buffer, keySerializer, valueSerializer);
        }
    }
    ,
    REPLACE_CONDITIONAL(6){

        @Override
        public <K, V> Operation<K, V> decode(ByteBuffer buffer, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
            return new ConditionalReplaceOperation<K, V>(buffer, keySerializer, valueSerializer);
        }
    };

    private final byte value;

    private OperationCode(byte value) {
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    public abstract <K, V> Operation<K, V> decode(ByteBuffer var1, Serializer<K> var2, Serializer<V> var3);

    public static OperationCode valueOf(byte value) {
        switch (value) {
            case 1: {
                return PUT;
            }
            case 2: {
                return REMOVE;
            }
            case 3: {
                return PUT_IF_ABSENT;
            }
            case 4: {
                return REMOVE_CONDITIONAL;
            }
            case 5: {
                return REPLACE;
            }
            case 6: {
                return REPLACE_CONDITIONAL;
            }
        }
        throw new IllegalArgumentException("Operation undefined for the value " + value);
    }
}

