/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.config;

import com.tc.config.schema.CommonL1Config;
import com.tc.config.schema.setup.L1ConfigurationSetupManager;
import com.tc.object.config.ClientConfig;
import com.tc.properties.ReconnectConfig;
import com.tc.properties.TCPropertiesImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConfigImpl
implements ClientConfig {
    private static final Logger logger = LoggerFactory.getLogger(ClientConfigImpl.class);
    private final L1ConfigurationSetupManager configSetupManager;
    private final ReconnectConfig l1ReconnectConfig = null;
    private final long CONFIGURATION_TOTAL_TIMEOUT;

    public ClientConfigImpl(boolean initializedModulesOnlyOnce, L1ConfigurationSetupManager configSetupManager) {
        this(configSetupManager);
    }

    public ClientConfigImpl(L1ConfigurationSetupManager configSetupManager) {
        this.configSetupManager = configSetupManager;
        TCPropertiesImpl.getProperties().overwriteTcPropertiesFromConfig(configSetupManager.getOverrideTCProperties());
        this.CONFIGURATION_TOTAL_TIMEOUT = TCPropertiesImpl.getProperties().getLong("tc.config.total.timeout");
    }

    @Override
    public String rawConfigText() {
        return this.configSetupManager.rawConfigText();
    }

    @Override
    public CommonL1Config getCommonL1Config() {
        return this.configSetupManager.commonL1Config();
    }

    public String toString() {
        return "<ClientConfigImpl: " + this.configSetupManager + ">";
    }
}

