/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.handler;

import com.tc.async.api.AbstractEventHandler;
import com.tc.cluster.ClusterEventsNotifier;
import com.tc.cluster.ClusterInternalEventsContext;
import com.tc.properties.TCPropertiesImpl;
import com.tc.text.PrettyPrintable;
import com.tc.text.PrettyPrinter;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterInternalEventsHandler<EC>
extends AbstractEventHandler<EC> {
    private static final Logger logger = LoggerFactory.getLogger(ClusterInternalEventsHandler.class);
    private static final int EXECUTOR_MAX_THREADS = TCPropertiesImpl.getProperties().getInt("l1.clusterevent.executor.maxThreads", 20);
    private static final long EXECUTOR_MAX_WAIT_SECONDS = TCPropertiesImpl.getProperties().getLong("l1.clusterevent.executor.maxWaitSeconds", 60L);
    private final ClusterEventsNotifier clusterEventsNotifier;
    private final ClusterEventExecutor clusterEventExecutor = new ClusterEventExecutor();

    public ClusterInternalEventsHandler(ClusterEventsNotifier eventsNotifier) {
        this.clusterEventsNotifier = eventsNotifier;
    }

    @Override
    public void handleEvent(final EC context) {
        ThreadPoolExecutor service = this.clusterEventExecutor.getExecutorService();
        Future<?> eventFuture = service.submit(new Runnable(){

            @Override
            public void run() {
                if (!(context instanceof ClusterInternalEventsContext)) {
                    throw new AssertionError((Object)("Unknown Context " + context));
                }
                ClusterInternalEventsContext eventContext = (ClusterInternalEventsContext)context;
                ClusterInternalEventsHandler.this.clusterEventsNotifier.notifyClusterListener(eventContext.getEventType(), eventContext.getEvent(), eventContext.getClusterListener());
            }
        });
        try {
            eventFuture.get(EXECUTOR_MAX_WAIT_SECONDS, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.info("clusterEventExecutor interrupted while waiting for result context :" + context, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (TimeoutException e) {
            logger.info("clusterEventExecutor timedout while waiting for result context :" + context, (Throwable)e);
        }
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        this.clusterEventExecutor.getExecutorService().shutdownNow();
    }

    static /* synthetic */ int access$200() {
        return EXECUTOR_MAX_THREADS;
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger();
        private final String threadName = "cluster-events-processor-";

        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "cluster-events-processor-" + this.threadNumber.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    }

    private static class ClusterEventExecutor
    implements PrettyPrintable {
        private final DaemonThreadFactory daemonThreadFactory = new DaemonThreadFactory();
        private final ThreadPoolExecutor eventExecutor = new ThreadPoolExecutor(1, ClusterInternalEventsHandler.access$200(), 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.daemonThreadFactory, new ThreadPoolExecutor.DiscardPolicy());

        private ClusterEventExecutor() {
        }

        public ThreadPoolExecutor getExecutorService() {
            return this.eventExecutor;
        }

        @Override
        public PrettyPrinter prettyPrint(PrettyPrinter out) {
            out.println("clusterEventExecutor active: " + this.eventExecutor.getActiveCount() + " queue: " + this.eventExecutor.getQueue().size()).flush();
            return out;
        }
    }
}

