/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.entity.VoltronEntityMessage;
import com.tc.net.protocol.tcm.TCMessage;
import com.tc.object.EntityID;
import com.tc.object.ExceptionUtils;
import com.tc.object.InFlightMonitor;
import com.tc.object.tx.TransactionID;
import com.tc.tracing.Trace;
import com.tc.util.Assert;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.terracotta.exception.EntityException;

public class InFlightMessage {
    private final VoltronEntityMessage message;
    private final EntityID eid;
    private final InFlightMonitor monitor;
    private final boolean isDeferred;
    private final Set<VoltronEntityMessage.Acks> pendingAcks;
    private final Set<Thread> waitingThreads;
    private boolean isSent;
    private EntityException exception;
    private byte[] value;
    private boolean canSetResult;
    private boolean getCanComplete;
    private final boolean blockGetOnRetired;
    private final Trace trace;

    public InFlightMessage(EntityID extraInfo, VoltronEntityMessage message, Set<VoltronEntityMessage.Acks> acks, InFlightMonitor monitor, boolean shouldBlockGetOnRetire, boolean isDeferred) {
        this.message = message;
        this.eid = extraInfo;
        this.monitor = monitor;
        Assert.assertNotNull(this.eid);
        Assert.assertNotNull(message);
        this.pendingAcks = EnumSet.noneOf(VoltronEntityMessage.Acks.class);
        this.pendingAcks.addAll(acks);
        this.waitingThreads = new HashSet<Thread>();
        this.blockGetOnRetired = shouldBlockGetOnRetire || isDeferred;
        this.canSetResult = true;
        this.trace = Trace.newTrace(message, "InFlightMessage");
        this.isDeferred = isDeferred;
    }

    public VoltronEntityMessage getMessage() {
        return this.message;
    }

    public TransactionID getTransactionID() {
        return this.message.getTransactionID();
    }

    public boolean send() {
        Trace.activeTrace().log("InFlightMessage.send()");
        Assert.assertFalse(this.isSent);
        this.isSent = true;
        return ((TCMessage)((Object)this.message)).send();
    }

    public void waitForAcks() {
        boolean interrupted = false;
        boolean complete = false;
        while (!complete) {
            try {
                this.waitForAcks(0L, TimeUnit.MILLISECONDS);
                complete = true;
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
            catch (TimeoutException te) {
                throw new AssertionError((Object)te);
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public void waitForAcks(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        Trace.activeTrace().log("InFlightMessage.waitForAcks");
        this.timedWait(() -> this.pendingAcks.isEmpty(), timeout, unit);
    }

    public synchronized void sent() {
        this.ackDelivered(VoltronEntityMessage.Acks.SENT);
        if (this.pendingAcks.isEmpty()) {
            this.notifyAll();
        }
    }

    public synchronized void received() {
        this.ackDelivered(VoltronEntityMessage.Acks.RECEIVED);
        if (this.pendingAcks.isEmpty()) {
            this.notifyAll();
        }
    }

    public synchronized void interrupt() {
        for (Thread waitingThread : this.waitingThreads) {
            waitingThread.interrupt();
        }
    }

    public synchronized boolean isDone() {
        return this.getCanComplete;
    }

    public synchronized byte[] get() throws InterruptedException, EntityException {
        try {
            return this.getWithTimeout(0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException to) {
            throw new AssertionError((Object)to);
        }
    }

    private synchronized void timedWait(Callable<Boolean> predicate, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        Thread callingThread = Thread.currentThread();
        boolean didAdd = this.waitingThreads.add(callingThread);
        Assert.assertTrue(didAdd);
        long end = timeout > 0L ? System.nanoTime() + unit.toNanos(timeout) : 0L;
        try {
            while (!predicate.call().booleanValue()) {
                long timing;
                long l = timing = end > 0L ? end - System.nanoTime() : 0L;
                if (timing < 0L) {
                    throw new TimeoutException();
                }
                this.wait(timing / TimeUnit.MILLISECONDS.toNanos(1L), (int)(timing % TimeUnit.MILLISECONDS.toNanos(1L)));
            }
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (TimeoutException to) {
            throw to;
        }
        catch (Exception exp) {
            throw new AssertionError((Object)exp);
        }
        finally {
            this.waitingThreads.remove(callingThread);
        }
    }

    public byte[] getWithTimeout(long timeout, TimeUnit unit) throws InterruptedException, EntityException, TimeoutException {
        this.trace.log("getWithTimeout()");
        this.timedWait(() -> this.getCanComplete, timeout, unit);
        if (this.exception != null) {
            throw ExceptionUtils.addLocalStackTraceToEntityException(this.eid, this.exception);
        }
        return this.value;
    }

    public synchronized void setResult(byte[] value, EntityException error) {
        this.trace.log("Received Result: " + value + " ; Exception: " + (error != null ? error.getLocalizedMessage() : "None"));
        this.ackDelivered(VoltronEntityMessage.Acks.RECEIVED);
        this.ackDelivered(VoltronEntityMessage.Acks.COMPLETED);
        if (this.pendingAcks.isEmpty()) {
            this.notifyAll();
        }
        if (error != null) {
            Assert.assertNull(value);
            this.pendingAcks.clear();
            this.exception = error;
            this.getCanComplete = true;
            this.notifyAll();
        } else {
            Assert.assertNull(error);
            if (this.isDeferred) {
                this.pushOneMessage(value);
            } else if (this.canSetResult) {
                this.value = value;
                if (!this.blockGetOnRetired) {
                    this.getCanComplete = true;
                    this.notifyAll();
                }
                this.canSetResult = this.blockGetOnRetired;
            }
        }
    }

    private void pushOneMessage(byte[] raw) {
        if (this.isDeferred && this.value != null && this.monitor != null) {
            this.monitor.accept(this.value);
        }
        this.value = raw;
    }

    public synchronized void handleMessage(byte[] raw) {
        this.pushOneMessage(raw);
    }

    private void ackDelivered(VoltronEntityMessage.Acks ack) {
        this.trace.log("Received ACK: " + (Object)((Object)ack));
        if (this.pendingAcks.remove((Object)ack) && this.monitor != null) {
            this.monitor.ackDelivered(ack);
        }
    }

    public synchronized void retired() {
        this.ackDelivered(VoltronEntityMessage.Acks.RETIRED);
        if (this.blockGetOnRetired) {
            this.getCanComplete = true;
        }
        this.notifyAll();
        if (this.monitor != null) {
            this.monitor.close();
        }
    }
}

