/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.config.builders;

import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.ehcache.clustered.client.config.ClusteringServiceConfiguration;
import org.ehcache.clustered.client.config.Timeouts;
import org.ehcache.clustered.client.config.builders.ServerSideConfigurationBuilder;
import org.ehcache.clustered.client.config.builders.TimeoutsBuilder;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.config.Builder;

public final class ClusteringServiceConfigurationBuilder
implements Builder<ClusteringServiceConfiguration> {
    private final URI clusterUri;
    private final Timeouts timeouts;
    private final boolean autoCreate;

    public static ClusteringServiceConfigurationBuilder cluster(URI clusterUri) {
        return new ClusteringServiceConfigurationBuilder(clusterUri, TimeoutsBuilder.timeouts().build(), false);
    }

    private ClusteringServiceConfigurationBuilder(URI clusterUri, Timeouts timeouts, boolean autoCreate) {
        this.clusterUri = Objects.requireNonNull(clusterUri, "Cluster URI can't be null");
        this.timeouts = Objects.requireNonNull(timeouts, "Timeouts can't be null");
        this.autoCreate = autoCreate;
    }

    public ServerSideConfigurationBuilder autoCreate() {
        return new ServerSideConfigurationBuilder(new ClusteringServiceConfigurationBuilder(this.clusterUri, this.timeouts, true));
    }

    public ServerSideConfigurationBuilder expecting() {
        return new ServerSideConfigurationBuilder(new ClusteringServiceConfigurationBuilder(this.clusterUri, this.timeouts, false));
    }

    public ClusteringServiceConfigurationBuilder timeouts(Timeouts timeouts) {
        return new ClusteringServiceConfigurationBuilder(this.clusterUri, timeouts, this.autoCreate);
    }

    public ClusteringServiceConfigurationBuilder timeouts(Builder<? extends Timeouts> timeoutsBuilder) {
        return new ClusteringServiceConfigurationBuilder(this.clusterUri, (Timeouts)timeoutsBuilder.build(), this.autoCreate);
    }

    @Deprecated
    public ClusteringServiceConfigurationBuilder readOperationTimeout(long duration, TimeUnit unit) {
        Duration readTimeout = Duration.of(duration, ClusteringServiceConfigurationBuilder.toChronoUnit(unit));
        return this.timeouts(TimeoutsBuilder.timeouts().read(readTimeout).build());
    }

    public ClusteringServiceConfiguration build() {
        return new ClusteringServiceConfiguration(this.clusterUri, this.timeouts, this.autoCreate, null);
    }

    ClusteringServiceConfiguration build(ServerSideConfiguration serverSideConfiguration) {
        return new ClusteringServiceConfiguration(this.clusterUri, this.timeouts, this.autoCreate, serverSideConfiguration);
    }

    private static ChronoUnit toChronoUnit(TimeUnit unit) {
        if (unit == null) {
            return null;
        }
        switch (unit) {
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        throw new AssertionError((Object)("Unknown unit: " + (Object)((Object)unit)));
    }
}

