/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.delivery;

import com.tc.net.protocol.delivery.AbstractState;
import com.tc.net.protocol.delivery.AbstractStateMachine;
import com.tc.net.protocol.delivery.OOOProtocolMessage;
import com.tc.net.protocol.delivery.OOOProtocolMessageDelivery;
import com.tc.net.protocol.delivery.State;
import com.tc.properties.ReconnectConfig;
import com.tc.util.Assert;
import com.tc.util.UUID;

public class ReceiveStateMachine
extends AbstractStateMachine {
    private final State MESSAGE_WAIT_STATE = new MessageWaitState();
    private final int maxDelayedAcks;
    private final String debugId;
    private final OOOProtocolMessageDelivery delivery;
    private static final boolean debug = false;
    private volatile long received = -1L;
    private volatile long lastAcked = -1L;

    public ReceiveStateMachine(OOOProtocolMessageDelivery delivery, ReconnectConfig reconnectConfig, boolean isClient) {
        this.maxDelayedAcks = reconnectConfig.getMaxDelayAcks();
        this.debugId = isClient ? "CLIENT" : "SERVER";
        this.delivery = delivery;
    }

    @Override
    public synchronized void execute(OOOProtocolMessage msg) {
        this.getCurrentState().execute(msg);
    }

    @Override
    protected State initialState() {
        return this.MESSAGE_WAIT_STATE;
    }

    @Override
    public String toString() {
        return "CurrentState: " + this.getCurrentState() + "; Received: " + this.received + "; lastAcked: " + this.lastAcked + "; " + super.toString();
    }

    private void putMessage(OOOProtocolMessage msg) {
        this.delivery.receiveMessage(msg);
    }

    private void ackIfNeeded(long next) {
        if (next - this.lastAcked >= (long)this.maxDelayedAcks && !this.sendAck(next)) {
            this.debugLog("Failed to send ack:" + next);
        }
    }

    private boolean sendAck(long seq) {
        OOOProtocolMessage opm = this.delivery.createAckMessage(seq);
        Assert.assertTrue(!opm.getSessionId().equals(UUID.NULL_ID));
        if (this.delivery.sendMessage(opm)) {
            this.lastAcked = seq;
            return true;
        }
        return false;
    }

    public long ackSequence() {
        this.lastAcked = this.received;
        return this.lastAcked;
    }

    @Override
    public synchronized void reset() {
        this.received = -1L;
        this.lastAcked = -1L;
    }

    private void debugLog(String msg) {
    }

    public synchronized long getReceived() {
        return this.received;
    }

    synchronized boolean isClean() {
        return this.received == -1L && this.lastAcked == -1L;
    }

    private class MessageWaitState
    extends AbstractState {
        public MessageWaitState() {
            super("MESSAGE_WAIT_STATE");
        }

        @Override
        public void execute(OOOProtocolMessage msg) {
            if (!msg.isSend()) {
                throw new AssertionError();
            }
            this.handleSendMessage(msg);
        }

        private void handleSendMessage(OOOProtocolMessage msg) {
            long r = msg.getSent();
            if (r <= ReceiveStateMachine.this.received) {
                ReceiveStateMachine.this.debugLog("Received dup msg " + r);
                ReceiveStateMachine.this.sendAck(ReceiveStateMachine.this.received);
            } else if (r > ReceiveStateMachine.this.received + 1L) {
                ReceiveStateMachine.this.debugLog("Received out of order msg " + r);
                ReceiveStateMachine.this.sendAck(ReceiveStateMachine.this.received);
            } else {
                Assert.assertTrue(r == ReceiveStateMachine.this.received + 1L);
                ReceiveStateMachine.this.putMessage(msg);
                ReceiveStateMachine.this.ackIfNeeded(ReceiveStateMachine.this.received = r);
            }
        }
    }
}

